/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLEngine;
import org.apache.activemq.transport.amqp.AmqpFrameParser;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.nio.NIOSSLTransport;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpNioSslTransport
extends NIOSSLTransport {
    private final AmqpFrameParser frameReader = new AmqpFrameParser((TcpTransport)this);

    public AmqpNioSslTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    public AmqpNioSslTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket, null, null, null);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    public AmqpNioSslTransport(WireFormat wireFormat, Socket socket, SSLEngine engine, TcpTransport.InitBuffer initBuffer, ByteBuffer inputBuffer) throws IOException {
        super(wireFormat, socket, engine, initBuffer, inputBuffer);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    protected void initializeStreams() throws IOException {
        super.initializeStreams();
        if (this.initBuffer != null) {
            this.initBuffer.buffer.flip();
            if (this.initBuffer.buffer.hasRemaining()) {
                this.receiveCounter.addAndGet(this.initBuffer.readSize);
                try {
                    this.processCommand(this.initBuffer.buffer);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                this.initBuffer.buffer.clear();
            }
        }
        if (this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining()) {
            this.serviceRead();
        }
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        this.frameReader.parse(plain);
    }

    protected void doInit() throws Exception {
        if (this.initBuffer != null) {
            this.nextFrameSize = -1;
        }
        super.doInit();
    }
}

