/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import org.apache.activemq.network.jms.DestinationBridge;

class QueueBridge
extends DestinationBridge {
    protected Queue consumerQueue;
    protected Queue producerQueue;
    protected QueueSession consumerSession;
    protected QueueSession producerSession;
    protected String selector;
    protected QueueSender producer;
    protected QueueConnection consumerConnection;
    protected QueueConnection producerConnection;

    QueueBridge() {
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.consumerSession != null) {
            this.consumerSession.close();
        }
        if (this.producerSession != null) {
            this.producerSession.close();
        }
    }

    @Override
    protected MessageConsumer createConsumer() throws JMSException {
        if (this.consumerConnection == null) {
            return null;
        }
        this.consumerSession = this.consumerConnection.createQueueSession(false, 2);
        QueueReceiver consumer = null;
        consumer = this.selector != null && this.selector.length() > 0 ? this.consumerSession.createReceiver(this.consumerQueue, this.selector) : this.consumerSession.createReceiver(this.consumerQueue);
        consumer.setMessageListener((MessageListener)this);
        return consumer;
    }

    @Override
    protected synchronized MessageProducer createProducer() throws JMSException {
        if (this.producerConnection == null) {
            return null;
        }
        this.producerSession = this.producerConnection.createQueueSession(false, 1);
        this.producer = this.producerSession.createSender(null);
        return this.producer;
    }

    @Override
    protected synchronized void sendMessage(Message message) throws JMSException {
        if (this.producer == null && this.createProducer() == null) {
            throw new JMSException("Producer for remote queue not available.");
        }
        try {
            this.producer.send(this.producerQueue, message);
        }
        catch (JMSException e) {
            this.producer = null;
            throw e;
        }
    }

    public QueueConnection getConsumerConnection() {
        return this.consumerConnection;
    }

    public void setConsumerConnection(QueueConnection consumerConnection) {
        this.consumerConnection = consumerConnection;
        if (this.started.get()) {
            try {
                this.createConsumer();
            }
            catch (Exception e) {
                this.jmsConnector.handleConnectionFailure(this.getConnnectionForConsumer());
            }
        }
    }

    public Queue getConsumerQueue() {
        return this.consumerQueue;
    }

    public void setConsumerQueue(Queue consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    public QueueConnection getProducerConnection() {
        return this.producerConnection;
    }

    public void setProducerConnection(QueueConnection producerConnection) {
        this.producerConnection = producerConnection;
    }

    public Queue getProducerQueue() {
        return this.producerQueue;
    }

    public void setProducerQueue(Queue producerQueue) {
        this.producerQueue = producerQueue;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Override
    protected Connection getConnnectionForConsumer() {
        return this.getConsumerConnection();
    }

    @Override
    protected Connection getConnectionForProducer() {
        return this.getProducerConnection();
    }
}

