// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package flatbuf

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// ----------------------------------------------------------------------
/// Data structures for dense tensors
/// Shape data for a single axis in a tensor
type TensorDim struct {
	_tab flatbuffers.Table
}

func GetRootAsTensorDim(buf []byte, offset flatbuffers.UOffsetT) *TensorDim {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &TensorDim{}
	x.Init(buf, n+offset)
	return x
}

func FinishTensorDimBuffer(builder *flatbuffers.Builder, offset flatbuffers.UOffsetT) {
	builder.Finish(offset)
}

func GetSizePrefixedRootAsTensorDim(buf []byte, offset flatbuffers.UOffsetT) *TensorDim {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &TensorDim{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func FinishSizePrefixedTensorDimBuffer(builder *flatbuffers.Builder, offset flatbuffers.UOffsetT) {
	builder.FinishSizePrefixed(offset)
}

func (rcv *TensorDim) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *TensorDim) Table() flatbuffers.Table {
	return rcv._tab
}

/// Length of dimension
func (rcv *TensorDim) Size() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

/// Length of dimension
func (rcv *TensorDim) MutateSize(n int64) bool {
	return rcv._tab.MutateInt64Slot(4, n)
}

/// Name of the dimension, optional
func (rcv *TensorDim) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Name of the dimension, optional
func TensorDimStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func TensorDimAddSize(builder *flatbuffers.Builder, size int64) {
	builder.PrependInt64Slot(0, size, 0)
}
func TensorDimAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(name), 0)
}
func TensorDimEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
