/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.main;

import org.apache.camel.CamelContext;
import org.apache.camel.support.LifecycleStrategySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A {@link org.apache.camel.spi.LifecycleStrategy} to trigger shutdown of the Main JVM when {@link CamelContext} is
 * stopped from JMX or its stop method is invoked from Java code.
 */
public class MainLifecycleStrategy extends LifecycleStrategySupport {
    private static final Logger LOG = LoggerFactory.getLogger(MainLifecycleStrategy.class);
    private final MainShutdownStrategy shutdownStrategy;

    public MainLifecycleStrategy(MainShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    @Override
    public void onContextStopping(CamelContext context) {
        LOG.debug("CamelContext: {} is stopping, triggering shutdown of the JVM.", context.getName());

        // trigger stopping the Main
        shutdownStrategy.shutdown();
    }
}
