/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.UnsafeCloseable;
import org.jetbrains.annotations.NotNull;

public class UncheckedLongReference
extends UnsafeCloseable
implements LongReference,
ReferenceOwner {
    private BytesStore bytes;

    @NotNull
    public static LongReference create(BytesStore bytesStore, long offset, int size) {
        @NotNull AbstractCloseable ref = Jvm.isDebug() ? new BinaryLongReference() : new UncheckedLongReference();
        ref.bytesStore(bytesStore, offset, size);
        return ref;
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes != bytes) {
            if (this.bytes != null) {
                this.bytes.release(this);
            }
            this.bytes = bytes;
            bytes.reserve(this);
        }
        this.address(bytes.addressForRead(offset));
    }

    @NotNull
    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.address;
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @Override
    @NotNull
    public String toString() {
        return this.address == 0L ? "addressForRead is 0" : "value: " + this.getValue();
    }

    @Override
    public long getValue() {
        return this.getLong();
    }

    @Override
    public void setValue(long value) {
        this.setLong(value);
    }

    @Override
    public long getVolatileValue() {
        return this.getVolatileLong();
    }

    @Override
    public void setVolatileValue(long value) {
        this.setVolatileLong(value);
    }

    @Override
    public long getVolatileValue(long closedValue) {
        return this.getVolatileLong(closedValue);
    }

    @Override
    public void setOrderedValue(long value) {
        this.setOrderedLong(value);
    }

    @Override
    public long addValue(long delta) {
        return this.addLong(delta);
    }

    @Override
    public long addAtomicValue(long delta) {
        return this.addAtomicLong(delta);
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) {
        return this.compareAndSwapLong(expected, value);
    }

    @Override
    protected void performClose() {
        if (this.bytes != null) {
            this.bytes.release(this);
        }
        this.bytes = null;
        super.performClose();
    }
}

