/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompactionWriter
extends CompactionAwareWriter {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCompactionWriter.class);
    private final int sstableLevel;

    public DefaultCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        this(cfs, directories, txn, nonExpiredSSTables, false, 0);
    }

    @Deprecated
    public DefaultCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline, boolean keepOriginals, int sstableLevel) {
        this(cfs, directories, txn, nonExpiredSSTables, keepOriginals, sstableLevel);
    }

    public DefaultCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean keepOriginals, int sstableLevel) {
        super(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
        this.sstableLevel = sstableLevel;
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        return this.sstableWriter.append(partition) != null;
    }

    @Override
    public void switchCompactionLocation(Directories.DataDirectory directory) {
        SSTableWriter writer = SSTableWriter.create(this.cfs.newSSTableDescriptor(this.getDirectories().getLocationForDisk(directory)), this.estimatedTotalKeys, (Long)this.minRepairedAt, this.pendingRepair, this.isTransient, this.cfs.metadata, new MetadataCollector(this.txn.originals(), this.cfs.metadata().comparator, this.sstableLevel), SerializationHeader.make(this.cfs.metadata(), this.nonExpiredSSTables), this.cfs.indexManager.listIndexes(), (LifecycleNewTracker)this.txn);
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }
}

