/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected volatile int responses = this.blockFor();
    private static final AtomicIntegerFieldUpdater<WriteResponseHandler> responsesUpdater = AtomicIntegerFieldUpdater.newUpdater(WriteResponseHandler.class, "responses");

    public WriteResponseHandler(ReplicaPlan.ForTokenWrite replicaPlan, Runnable callback, WriteType writeType, long queryStartNanoTime) {
        super(replicaPlan, callback, writeType, queryStartNanoTime);
    }

    public WriteResponseHandler(ReplicaPlan.ForTokenWrite replicaPlan, WriteType writeType, long queryStartNanoTime) {
        this(replicaPlan, null, writeType, queryStartNanoTime);
    }

    @Override
    public void onResponse(Message<T> m3) {
        if (responsesUpdater.decrementAndGet(this) == 0) {
            this.signal();
        }
        this.logResponseToIdealCLDelegate(m3);
    }

    @Override
    protected int ackCount() {
        return this.blockFor() - this.responses;
    }
}

