/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.cassandra.transport.ClientStat;
import org.apache.cassandra.transport.ProtocolVersion;

public class ProtocolVersionTracker {
    private static final int DEFAULT_MAX_CAPACITY = 100;
    private final EnumMap<ProtocolVersion, LoadingCache<InetAddress, Long>> clientsByProtocolVersion = new EnumMap(ProtocolVersion.class);

    ProtocolVersionTracker() {
        this(100);
    }

    private ProtocolVersionTracker(int capacity) {
        for (ProtocolVersion version : ProtocolVersion.values()) {
            this.clientsByProtocolVersion.put(version, Caffeine.newBuilder().maximumSize(capacity).build(key -> System.currentTimeMillis()));
        }
    }

    void addConnection(InetAddress addr, ProtocolVersion version) {
        this.clientsByProtocolVersion.get(version).put(addr, System.currentTimeMillis());
    }

    List<ClientStat> getAll() {
        ArrayList<ClientStat> result = new ArrayList<ClientStat>();
        this.clientsByProtocolVersion.forEach((version, cache) -> cache.asMap().forEach((address, lastSeenTime) -> result.add(new ClientStat((InetAddress)address, (ProtocolVersion)version, (long)lastSeenTime))));
        return result;
    }

    List<ClientStat> getAll(ProtocolVersion version) {
        ArrayList<ClientStat> result = new ArrayList<ClientStat>();
        this.clientsByProtocolVersion.get(version).asMap().forEach((address, lastSeenTime) -> result.add(new ClientStat((InetAddress)address, version, (long)lastSeenTime)));
        return result;
    }

    public void clear() {
        this.clientsByProtocolVersion.values().forEach(Cache::invalidateAll);
    }
}

