/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.util.Comparator;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.bridge.type.InternalDuration;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.utils.SparkTypeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.jetbrains.annotations.NotNull;

public class SparkDuration
implements SparkType {
    public static final SparkDuration INSTANCE = new SparkDuration();
    private static final Comparator<CalendarInterval> CALENDAR_INTERVAL_COMPARATOR = SparkTypeUtils.CALENDAR_INTERVAL_COMPARATOR;

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.CalendarIntervalType;
    }

    @Override
    public Object nativeSparkSqlRowValue(Row row, int position) {
        return row.isNullAt(position) ? null : row.get(position);
    }

    @Override
    public Object nativeSparkSqlRowValue(GenericInternalRow row, int position) {
        return row.isNullAt(position) ? null : row.getInterval(position);
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        InternalDuration duration = (InternalDuration)value;
        return SparkTypeUtils.convertDuration(duration);
    }

    @Override
    public Object toTestRowType(Object value) {
        CalendarInterval ci = (CalendarInterval)value;
        return SparkTypeUtils.convertDuration(ci);
    }

    @Override
    public int compareTo(Object first, Object second) {
        return CALENDAR_INTERVAL_COMPARATOR.compare((CalendarInterval)first, (CalendarInterval)second);
    }
}

