/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.Sizing;
import org.apache.cassandra.spark.data.TableSizeProvider;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSizing
implements Sizing {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSizing.class);
    private final ReplicationFactor replicationFactor;
    private final int maxPartitionSize;
    private final int availableCores;
    private final String keyspace;
    private final String table;
    private final String dc;
    private final TableSizeProvider tableSizeProvider;
    private final ConsistencyLevel consistencyLevel;

    public DynamicSizing(TableSizeProvider tableSizeProvider, ConsistencyLevel consistencyLevel, ReplicationFactor replicationFactor, String keyspace, String table, String datacenter, int maxPartitionSize, int availableCores) {
        this.tableSizeProvider = tableSizeProvider;
        this.consistencyLevel = consistencyLevel;
        this.replicationFactor = replicationFactor;
        this.keyspace = keyspace;
        this.table = table;
        this.dc = datacenter;
        this.maxPartitionSize = maxPartitionSize;
        this.availableCores = availableCores;
    }

    @Override
    public int getEffectiveNumberOfCores() {
        double tableSizeInGiB = (double)this.tableSizeProvider.tableSizeInBytes(this.keyspace, this.table, this.dc) / 1.073741824E9;
        double minReplicas = this.consistencyLevel.blockFor(this.replicationFactor, this.dc);
        int effectiveNumberOfCores = Math.min(Math.max(1, (int)Math.ceil(tableSizeInGiB * minReplicas / (double)this.maxPartitionSize)), this.availableCores);
        LOGGER.info("Using Dynamic Sizing. tableSize {}GiB, minReplicas {}, maxPartitionSize {}GiB, availableCores {}, effectiveNumberOfCores {}", new Object[]{tableSizeInGiB, minReplicas, this.maxPartitionSize, this.availableCores, effectiveNumberOfCores});
        return effectiveNumberOfCores;
    }
}

