/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ConsistencyLevel {
    ANY(0),
    ONE(1),
    TWO(2),
    THREE(3),
    QUORUM(4),
    ALL(5),
    LOCAL_QUORUM(6, true),
    EACH_QUORUM(7),
    SERIAL(8),
    LOCAL_SERIAL(9),
    LOCAL_ONE(10, true);

    public final int code;
    public final boolean isDCLocal;

    private ConsistencyLevel(int code) {
        this(code, false);
    }

    private ConsistencyLevel(int code, boolean isDCLocal) {
        this.code = code;
        this.isDCLocal = isDCLocal;
    }

    private int quorumFor(ReplicationFactor replicationFactor) {
        return replicationFactor.getTotalReplicationFactor() / 2 + 1;
    }

    private int localQuorumFor(@NotNull ReplicationFactor replicationFactor, @Nullable String dataCenter) {
        return replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy ? this.getNetworkTopologyRf(replicationFactor, dataCenter) : this.quorumFor(replicationFactor);
    }

    public Map<String, Integer> eachQuorumBlockFor(@NotNull ReplicationFactor replicationFactor) {
        if (this != EACH_QUORUM) {
            throw new IllegalArgumentException(String.format("Consistency level needed is EACH_QUORUM, provided is: %s", this.name()));
        }
        if (replicationFactor.getReplicationStrategy() != ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy) {
            throw new IllegalArgumentException(String.format("Invalid Replication Strategy: %s for EACH_QUORUM consistency read.", replicationFactor.getReplicationStrategy().name()));
        }
        return replicationFactor.getOptions().keySet().stream().collect(Collectors.toMap(dataCenter -> dataCenter, dataCenter -> this.localQuorumFor(replicationFactor, (String)dataCenter)));
    }

    private int getNetworkTopologyRf(@NotNull ReplicationFactor replicationFactor, @Nullable String dataCenter) {
        int rf;
        if (dataCenter == null && replicationFactor.getOptions().size() == 1) {
            rf = replicationFactor.getOptions().values().iterator().next();
        } else {
            if (!replicationFactor.getOptions().containsKey(dataCenter)) {
                throw new IllegalArgumentException(String.format("Data center %s not found in replication factor %s", dataCenter, replicationFactor.getOptions().keySet()));
            }
            rf = replicationFactor.getOptions().get(dataCenter);
        }
        return rf / 2 + 1;
    }

    public int blockFor(@NotNull ReplicationFactor replicationFactor, @Nullable String dataCenter) {
        switch (this) {
            case ONE: 
            case LOCAL_ONE: 
            case ANY: {
                return 1;
            }
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case QUORUM: 
            case SERIAL: {
                return this.quorumFor(replicationFactor);
            }
            case ALL: {
                return replicationFactor.getTotalReplicationFactor();
            }
            case LOCAL_QUORUM: 
            case LOCAL_SERIAL: {
                return this.localQuorumFor(replicationFactor, dataCenter);
            }
            case EACH_QUORUM: {
                if (replicationFactor.getReplicationStrategy() == ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy) {
                    int count = 0;
                    for (String datacenter : replicationFactor.getOptions().keySet()) {
                        count += this.localQuorumFor(replicationFactor, datacenter);
                    }
                    return count;
                }
                return this.quorumFor(replicationFactor);
            }
        }
        throw new UnsupportedOperationException("Invalid consistency level: " + this.toString());
    }
}

