/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.spark.utils.ByteBufferUtils;

public class RowData {
    private ByteBuffer partitionKey;
    private ByteBuffer columnName;
    private ByteBuffer value;
    private long timestamp;
    private BigInteger token;
    @VisibleForTesting
    boolean isNewPartition = false;

    public void setPartitionKeyCopy(ByteBuffer partitionKeyBytes, BigInteger token) {
        this.partitionKey = partitionKeyBytes;
        this.token = token;
        this.columnName = null;
        this.value = null;
        this.isNewPartition = true;
        this.timestamp = 0L;
    }

    public boolean isNewPartition() {
        if (this.isNewPartition) {
            this.isNewPartition = false;
            return true;
        }
        return false;
    }

    public ByteBuffer getPartitionKey() {
        return this.partitionKey;
    }

    public BigInteger getToken() {
        return this.token;
    }

    public void setColumnNameCopy(ByteBuffer columnBytes) {
        this.columnName = columnBytes;
    }

    public ByteBuffer getColumnName() {
        return this.columnName;
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public void setValueCopy(ByteBuffer value) {
        this.value = value;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return ByteBufferUtils.toHexString(this.getPartitionKey()) + ":" + ByteBufferUtils.toHexString(this.getColumnName()) + ":" + ByteBufferUtils.toHexString(this.getValue());
    }
}

