/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.Cell;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CellIterator
implements Iterator<Cell>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellIterator.class);
    private final Stats stats;
    protected final CqlTable cqlTable;
    private final Object[] values;
    @Nullable
    private final PruneColumnFilter columnFilter;
    private final long startTimeNanos;
    @NotNull
    private final StreamScanner<RowData> scanner;
    @NotNull
    private final RowData rowData;
    private boolean skipPartition = false;
    private boolean newRow = false;
    private boolean closed = false;
    private Cell next = null;
    private long previousTimeNanos;
    protected final int partitionId;
    protected final int firstProjectedValueColumnPositionOrZero;
    private final boolean hasProjectedValueColumns;
    protected final TypeConverter typeConverter;

    public CellIterator(int partitionId, CqlTable cqlTable, Stats stats, TypeConverter typeConverter, @NotNull List<PartitionKeyFilter> partitionKeyFilters, @NotNull SSTableTimeRangeFilter sstableTimeRangeFilter, Function<CqlTable, PruneColumnFilter> columnFilterSupplier, ScannerSupplier scannerSupplier) {
        this.partitionId = partitionId;
        this.stats = stats;
        this.cqlTable = cqlTable;
        this.typeConverter = typeConverter;
        this.columnFilter = columnFilterSupplier.apply(cqlTable);
        if (this.columnFilter != null) {
            LOGGER.info("Adding prune column filter columns='{}'", (Object)String.join((CharSequence)",", this.columnFilter.requiredColumns()));
        }
        this.hasProjectedValueColumns = cqlTable.numValueColumns() > 0 && cqlTable.valueColumns().stream().anyMatch(field -> this.columnFilter == null || this.columnFilter.requiredColumns().contains(field.name()));
        this.values = new Object[cqlTable.numNonValueColumns() + (this.hasProjectedValueColumns ? 1 : 0)];
        this.previousTimeNanos = this.startTimeNanos = System.nanoTime();
        this.scanner = scannerSupplier.get(partitionId, partitionKeyFilters, sstableTimeRangeFilter, this.columnFilter);
        long openTimeNanos = System.nanoTime() - this.startTimeNanos;
        LOGGER.info("Opened CompactionScanner runtimeNanos={}", (Object)openTimeNanos);
        stats.openedCompactionScanner(openTimeNanos);
        this.rowData = this.scanner.data();
        stats.openedSparkCellIterator();
        this.firstProjectedValueColumnPositionOrZero = this.maybeGetPositionOfFirstProjectedValueColumnOrZero();
    }

    public CqlTable cqlTable() {
        return this.cqlTable;
    }

    public boolean hasProjectedValueColumns() {
        return this.hasProjectedValueColumns;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextThrows();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean hasNextThrows() throws IOException {
        if (this.next != null || this.closed) {
            return !this.closed;
        }
        return this.getNext();
    }

    @Override
    public Cell next() {
        Cell result = this.next;
        assert (result != null);
        this.next = null;
        this.newRow = false;
        long now = System.nanoTime();
        this.stats.nextCell(now - this.previousTimeNanos);
        this.previousTimeNanos = now;
        return result;
    }

    private boolean getNext() throws IOException {
        while (this.scanner.next()) {
            this.maybeRebuildPartition();
            this.scanner.advanceToNextColumn();
            if (this.skipPartition) continue;
            ByteBuffer columnNameBuf = Objects.requireNonNull(this.rowData.getColumnName(), "ColumnName buffer in RowData is null, this is unexpected");
            this.maybeRebuildClusteringKeys(columnNameBuf);
            ByteBuffer component = ByteBufferUtils.extractComponent(columnNameBuf, this.cqlTable.numClusteringKeys());
            String columnName = this.decodeString(component);
            if (columnName == null || columnName.isEmpty()) {
                if (this.hasProjectedValueColumns && this.scanner.hasMoreColumns()) continue;
                if (this.hasProjectedValueColumns) {
                    this.values[this.values.length - 1] = null;
                }
                this.next = new Cell(this.values, this.firstProjectedValueColumnPositionOrZero, this.newRow, this.rowData.getTimestamp());
                return true;
            }
            CqlField field = this.cqlTable.getField(columnName);
            if (field == null) {
                LOGGER.warn("Ignoring unknown column columnName='{}'", (Object)columnName);
                continue;
            }
            this.deserializeField(field);
            if (field.isStaticColumn()) continue;
            this.next = new Cell(this.values, field.position(), this.newRow, this.rowData.getTimestamp());
            return true;
        }
        this.next = null;
        this.close();
        return false;
    }

    protected String decodeString(@Nullable ByteBuffer buffer) throws CharacterCodingException {
        return buffer == null ? null : ByteBufferUtils.string(buffer);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.scanner.close();
            this.closed = true;
            long runtimeNanos = System.nanoTime() - this.startTimeNanos;
            LOGGER.info("Closed CompactionScanner runtimeNanos={}", (Object)runtimeNanos);
            this.stats.closedSparkCellIterator(runtimeNanos);
        }
    }

    private void maybeRebuildPartition() {
        if (!this.rowData.isNewPartition()) {
            return;
        }
        this.newRow = true;
        for (CqlField field : this.cqlTable.staticColumns()) {
            this.values[field.position()] = null;
        }
        boolean bl = this.skipPartition = !this.isInPartition(this.partitionId, this.rowData.getToken(), this.rowData.getPartitionKey());
        if (this.skipPartition) {
            this.stats.skippedPartitionInIterator(this.rowData.getPartitionKey(), this.rowData.getToken());
            return;
        }
        CellIterator.readPartitionKey(this.typeConverter, this.rowData.getPartitionKey(), this.cqlTable, this.values, this.stats);
    }

    public abstract boolean isInPartition(int var1, BigInteger var2, ByteBuffer var3);

    public abstract boolean equals(CqlField var1, Object var2, Object var3);

    public static void readPartitionKey(TypeConverter typeConverter, ByteBuffer partitionKey, CqlTable table, Object[] values, Stats stats) {
        if (table.numPartitionKeys() == 1) {
            CqlField field = table.partitionKeys().get(0);
            values[field.position()] = CellIterator.deserialize(typeConverter, field, partitionKey, stats);
        } else {
            ByteBuffer[] partitionKeyBufs = ByteBufferUtils.split(partitionKey, table.numPartitionKeys());
            int index = 0;
            for (CqlField field : table.partitionKeys()) {
                values[field.position()] = CellIterator.deserialize(typeConverter, field, partitionKeyBufs[index++], stats);
            }
        }
    }

    private void maybeRebuildClusteringKeys(@NotNull ByteBuffer columnNameBuf) {
        List<CqlField> clusteringKeys = this.cqlTable.clusteringKeys();
        if (clusteringKeys.isEmpty()) {
            return;
        }
        int index = 0;
        for (CqlField field : clusteringKeys) {
            Object newObj = this.deserialize(field, ByteBufferUtils.extractComponent(columnNameBuf, index++));
            Object oldObj = this.values[field.position()];
            if (!this.newRow && oldObj != null && newObj != null && this.equals(field, newObj, oldObj)) continue;
            this.newRow = true;
            this.values[field.position()] = newObj;
        }
    }

    private void deserializeField(@NotNull CqlField field) {
        if (this.columnFilter == null || this.columnFilter.includeColumn(field.name())) {
            Object value = this.deserialize(field, this.rowData.getValue());
            if (field.isStaticColumn()) {
                this.values[field.position()] = value;
                return;
            }
            this.values[this.values.length - 1] = value;
        }
    }

    private Object deserialize(CqlField field, ByteBuffer buffer) {
        return CellIterator.deserialize(this.typeConverter, field, buffer, this.stats);
    }

    private static Object deserialize(TypeConverter typeConverter, CqlField field, ByteBuffer buffer, Stats stats) {
        long now = System.nanoTime();
        Object value = buffer == null ? null : field.deserializeToType(typeConverter, buffer);
        stats.fieldDeserialization(field, System.nanoTime() - now);
        return value;
    }

    private int maybeGetPositionOfFirstProjectedValueColumnOrZero() {
        for (CqlField valueColumn : this.cqlTable.valueColumns()) {
            if (this.columnFilter != null && !this.columnFilter.includeColumn(valueColumn.name())) continue;
            return valueColumn.position();
        }
        return 0;
    }

    public static interface ScannerSupplier {
        public StreamScanner<RowData> get(int var1, @NotNull List<PartitionKeyFilter> var2, @NotNull SSTableTimeRangeFilter var3, @Nullable PruneColumnFilter var4);
    }
}

