/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql.filters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PruneColumnFilter {
    private final Set<String> requiredColumns;

    public PruneColumnFilter(@NotNull Set<String> requiredColumns) {
        this.requiredColumns = requiredColumns;
    }

    @Nullable
    public static PruneColumnFilter of(@Nullable String[] requiredColumns) {
        return requiredColumns == null ? null : new PruneColumnFilter(new HashSet<String>(Arrays.asList(requiredColumns)));
    }

    public Set<String> requiredColumns() {
        return this.requiredColumns;
    }

    public int size() {
        return this.requiredColumns.size();
    }

    public boolean includeColumn(String columnName) {
        return this.requiredColumns.contains(columnName);
    }
}

