/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClientSource
implements CassandraSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraClientSource.class);
    private static final String READ_QUERY_FORMAT = "SELECT %s from %s.%s where %s";
    private static final int EXPIRE_AFTER_MINUTES = 60;
    private final Session session;
    private final CassandraTypes types;
    private final Cache<String, PreparedStatement> preparedStatementCache;

    public CassandraClientSource(Session session, CassandraTypes types) {
        this(session, types, 60);
    }

    public CassandraClientSource(Session session, CassandraTypes types, int preparedStatementCacheExpireAfterMinutes) {
        this.session = session;
        this.types = types;
        this.preparedStatementCache = CacheBuilder.newBuilder().expireAfterAccess((long)preparedStatementCacheExpireAfterMinutes, TimeUnit.MINUTES).build();
    }

    public List<ByteBuffer> readFromCassandra(String keyspace, String table, List<String> columnsToFetch, List<Value> primaryKeyColumns) {
        PreparedStatement preparedStatement;
        List<String> primaryKeyColumnNames = CassandraClientSource.getPrimaryKeyColumnNames(primaryKeyColumns);
        String readQuery = CassandraClientSource.getReadQuery(keyspace, table, columnsToFetch, primaryKeyColumnNames);
        try {
            preparedStatement = (PreparedStatement)this.preparedStatementCache.get((Object)readQuery, () -> this.session.prepare(readQuery));
        }
        catch (ExecutionException e) {
            LOGGER.error("Unable to load prepared statement for query {}", (Object)readQuery, (Object)e);
            preparedStatement = this.session.prepare(readQuery);
        }
        BoundStatement boundStatement = preparedStatement.bind(CassandraClientSource.getPrimaryKeyObjects(this.types, primaryKeyColumns));
        ResultSet resultSet = this.session.execute((Statement)boundStatement);
        if (resultSet.isExhausted()) {
            LOGGER.error("The read query {} to C* failed", (Object)readQuery);
            return null;
        }
        Row row = resultSet.one();
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (String column : columnsToFetch) {
            result.add(row.getBytesUnsafe(column));
        }
        return result;
    }

    @VisibleForTesting
    static String getReadQuery(String keyspace, String table, List<String> columnsToFetch, List<String> primaryKeyColumns) {
        String columnsToSelect = StringUtils.join(columnsToFetch, (String)",");
        String primaryKeyCondition = primaryKeyColumns.stream().map(primaryKeyColumn -> primaryKeyColumn + " = ?").collect(Collectors.joining(" , "));
        return String.format(READ_QUERY_FORMAT, columnsToSelect, keyspace, table, primaryKeyCondition);
    }

    @VisibleForTesting
    static Object[] getPrimaryKeyObjects(CassandraTypes types, List<Value> primaryKeyColumns) {
        return primaryKeyColumns.stream().map(valueWithMetadata -> types.parseType(valueWithMetadata.columnType).deserializeToJavaType(valueWithMetadata.getValue())).toArray();
    }

    private static List<String> getPrimaryKeyColumnNames(List<Value> primaryKeyColumns) {
        return primaryKeyColumns.stream().map(valueWithMetadata -> valueWithMetadata.columnName).collect(Collectors.toList());
    }

    private static class MtlsAuthProvider
    implements AuthProvider {
        private MtlsAuthProvider() {
        }

        public Authenticator newAuthenticator(InetSocketAddress inetSocketAddress, String s) throws AuthenticationException {
            return new MutualTLSAuthenticator();
        }

        private static class MutualTLSAuthenticator
        implements Authenticator {
            private MutualTLSAuthenticator() {
            }

            public byte[] initialResponse() {
                return new byte[]{0, 0};
            }

            public byte[] evaluateChallenge(byte[] bytes) {
                return null;
            }

            public void onAuthenticationSuccess(byte[] bytes) {
                LOGGER.info("Successfully authenticated with mTLS");
            }
        }
    }
}

