/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import java.time.Duration;
import o.a.c.sidecar.client.shaded.common.response.data.CdcSegmentInfo;
import o.a.c.sidecar.client.shaded.common.utils.HttpRange;
import org.apache.cassandra.cdc.api.CommitLog;
import org.apache.cassandra.cdc.sidecar.SidecarCdcClient;
import org.apache.cassandra.cdc.stats.ICdcStats;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.jetbrains.annotations.Nullable;

public class SidecarCdcCommitLogSegment
implements CommitLog {
    private final CassandraInstance instance;
    private final CdcSegmentInfo segment;
    private final CassandraFileSource<CommitLog> source;
    private final ICdcStats stats;

    public SidecarCdcCommitLogSegment(final SidecarCdcClient sidecar, final CassandraInstance instance, final CdcSegmentInfo segment, final SidecarCdcClient.ClientConfig clientConfig) {
        this.instance = instance;
        this.segment = segment;
        this.stats = sidecar.stats;
        final SidecarCdcCommitLogSegment thisLog = this;
        this.source = new CassandraFileSource<CommitLog>(){

            public void request(long start, long end, StreamConsumer consumer) {
                sidecar.streamCdcCommitLogSegment(instance, segment.name, HttpRange.of((long)start, (long)end), consumer);
            }

            public CommitLog cassandraFile() {
                return thisLog;
            }

            public long maxBufferSize() {
                return clientConfig.maxBufferSize();
            }

            public long chunkBufferSize() {
                return clientConfig.chunkBufferSize(this.fileType());
            }

            public FileType fileType() {
                return FileType.COMMITLOG;
            }

            public long size() {
                return segment.idx;
            }

            @Nullable
            public Duration timeout() {
                int timeout = clientConfig.timeoutSeconds();
                return timeout <= 0 ? null : Duration.ofSeconds(timeout);
            }
        };
    }

    public String name() {
        return this.segment.name;
    }

    public String path() {
        return "./" + this.segment.name;
    }

    public long maxOffset() {
        return this.segment.idx;
    }

    public long length() {
        return this.segment.size;
    }

    public boolean completed() {
        return this.segment.completed;
    }

    public CassandraFileSource<CommitLog> source() {
        return this.source;
    }

    public CassandraInstance instance() {
        return this.instance;
    }

    public ICdcStats stats() {
        return this.stats;
    }

    public void close() {
    }

    public String toString() {
        return "{\"node\": \"" + this.instance.nodeName() + "\",\"dc\": \"" + this.instance.dataCenter() + "\",\"token\": \"" + this.instance.token() + "\",\"log\": \"" + this.segment.name + "\",\"idx\": \"" + this.segment.idx + "\",\"size\": \"" + this.segment.size + "\"}";
    }
}

