/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelHandlerContext;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.FullHttpResponse;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpRequest;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import o.a.c.sidecar.client.shaded.io.netty.util.CharsetUtil;
import o.a.c.sidecar.client.shaded.io.netty.util.collection.CharObjectMap;
import o.a.c.sidecar.client.shaded.io.vertx.core.buffer.Buffer;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.Http2Settings;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpUtils;

public class VertxHttp2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final Http2Settings settings;

    public VertxHttp2ClientUpgradeCodec(Http2Settings settings) {
        this.settings = settings;
    }

    @Override
    public CharSequence protocol() {
        return "h2c";
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        o.a.c.sidecar.client.shaded.io.netty.handler.codec.http2.Http2Settings nettySettings = new o.a.c.sidecar.client.shaded.io.netty.handler.codec.http2.Http2Settings();
        HttpUtils.fromVertxInitialSettings(false, this.settings, nettySettings);
        Buffer buf = Buffer.buffer();
        for (CharObjectMap.PrimitiveEntry entry : nettySettings.entries()) {
            buf.appendUnsignedShort(entry.key());
            buf.appendUnsignedInt((Long)entry.value());
        }
        String encodedSettings = new String(Base64.getUrlEncoder().encode(buf.getBytes()), CharsetUtil.UTF_8);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)encodedSettings);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
    }
}

