/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.impl;

import java.util.concurrent.Callable;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.Nullable;
import o.a.c.sidecar.client.shaded.io.vertx.core.AsyncResult;
import o.a.c.sidecar.client.shaded.io.vertx.core.Future;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.Promise;
import o.a.c.sidecar.client.shaded.io.vertx.core.Vertx;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.CloseFuture;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.DuplicatedContext;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.VertxInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.WorkerExecutorInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.WorkerPool;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.future.PromiseInternal;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.Metrics;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.MetricsProvider;
import o.a.c.sidecar.client.shaded.io.vertx.core.spi.metrics.PoolMetrics;

class WorkerExecutorImpl
implements MetricsProvider,
WorkerExecutorInternal {
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final VertxImpl.SharedWorkerPool pool;
    private boolean closed;

    public WorkerExecutorImpl(VertxInternal vertx, CloseFuture closeFuture, VertxImpl.SharedWorkerPool pool) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.pool = pool;
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public WorkerPool getPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            if (this.closed) {
                throw new IllegalStateException("Worker executor closed");
            }
        }
        ContextInternal context = this.vertx.getOrCreateContext();
        ContextImpl impl = context instanceof DuplicatedContext ? ((DuplicatedContext)context).delegate : (ContextImpl)context;
        return ContextImpl.executeBlocking(context, blockingCodeHandler, (WorkerPool)this.pool, ordered ? impl.orderedTasks : null);
    }

    @Override
    public <T> Future<@Nullable T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        ContextInternal context = this.vertx.getOrCreateContext();
        ContextImpl impl = context instanceof DuplicatedContext ? ((DuplicatedContext)context).delegate : (ContextImpl)context;
        return ContextImpl.executeBlocking(context, blockingCodeHandler, (WorkerPool)this.pool, ordered ? impl.orderedTasks : null);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        if (asyncResultHandler != null) {
            fut.onComplete(asyncResultHandler);
        }
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> completion) {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            this.closed = true;
        }
        this.pool.close();
        completion.complete();
    }
}

