/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.net;

import java.net.InetSocketAddress;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.CacheReturn;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.GenIgnore;
import o.a.c.sidecar.client.shaded.io.vertx.codegen.annotations.VertxGen;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.Arguments;
import o.a.c.sidecar.client.shaded.io.vertx.core.net.impl.SocketAddressImpl;

@VertxGen
public interface SocketAddress {
    public static SocketAddress sharedRandomPort(int id, String host) {
        if (id < 1) {
            throw new IllegalArgumentException("Shared random port ID " + id + " must be > 0");
        }
        return new SocketAddressImpl(-id, host);
    }

    public static SocketAddress inetSocketAddress(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        return new SocketAddressImpl(port, host);
    }

    public static SocketAddress domainSocketAddress(String path) {
        return new SocketAddressImpl(path);
    }

    @GenIgnore(value={"permitted-type"})
    public static SocketAddress inetSocketAddress(InetSocketAddress address) {
        return new SocketAddressImpl(address);
    }

    @CacheReturn
    public String host();

    @CacheReturn
    public String hostName();

    @CacheReturn
    public String hostAddress();

    @CacheReturn
    public int port();

    @CacheReturn
    public String path();

    @CacheReturn
    public boolean isInetSocket();

    @CacheReturn
    public boolean isDomainSocket();
}

