/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.secrets;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.apache.cassandra.secrets.SecretsProvider;

public final class TestSecretsProvider
implements SecretsProvider {
    private final Kind kind;
    private final String type;
    private final String resource;
    private final String password;

    public static SecretsProvider notConfigured() {
        return new TestSecretsProvider(Kind.None, null, null, null);
    }

    public static SecretsProvider forKeyStore(String type, String resource, String password) {
        return new TestSecretsProvider(Kind.KeyStore, type, resource, password);
    }

    public static SecretsProvider forTrustStore(String type, String resource, String password) {
        return new TestSecretsProvider(Kind.TrustStore, type, resource, password);
    }

    private TestSecretsProvider(Kind kind, String type, String resource, String password) {
        this.kind = kind;
        this.type = type;
        this.resource = "/validation/" + resource;
        this.password = password;
    }

    public boolean hasKeyStoreSecrets() {
        return this.kind == Kind.KeyStore;
    }

    public String keyStoreType() {
        return this.kind == Kind.KeyStore ? this.type : null;
    }

    public InputStream keyStoreInputStream() {
        return this.kind == Kind.KeyStore ? this.getClass().getResourceAsStream(this.resource) : null;
    }

    public char[] keyStorePassword() {
        return this.kind == Kind.KeyStore ? this.password.toCharArray() : null;
    }

    public boolean hasTrustStoreSecrets() {
        return this.kind == Kind.TrustStore;
    }

    public String trustStoreType() {
        return this.kind == Kind.TrustStore ? this.type : null;
    }

    public InputStream trustStoreInputStream() {
        return this.kind == Kind.TrustStore ? this.getClass().getResourceAsStream(this.resource) : null;
    }

    public char[] trustStorePassword() {
        return this.kind == Kind.TrustStore ? this.password.toCharArray() : null;
    }

    public void initialize(Map<String, String> options) {
    }

    public void validateMutualTLS() {
    }

    public String secretByName(String secretName) {
        return null;
    }

    public Path secretsPath() {
        return null;
    }

    private static enum Kind {
        None,
        KeyStore,
        TrustStore;

    }
}

