/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark;

import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.TestDataLayer;
import org.apache.cassandra.spark.TestRunnable;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.BasicSupplier;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.reader.RowData;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.filters.SSTableTimeRangeFilter;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.cassandra.spark.utils.TimeProvider;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;

public class SSTableReaderTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCollectionWithTtlUsingConstantReferenceTime(CassandraBridge bridge) {
        this.testTtlUsingConstantReferenceTimeHelper(bridge, 50, 0, 10, 10);
        this.testTtlUsingConstantReferenceTimeHelper(bridge, 50, 100, 10, 0);
    }

    private void testTtlUsingConstantReferenceTimeHelper(CassandraBridge bridgeForTest, int ttlSecs, int timeOffsetSecs, int rows, int expectedValues) {
        AtomicInteger referenceEpoch = new AtomicInteger(0);
        TimeProvider navigatableTimeProvider = referenceEpoch::get;
        HashSet<Integer> expectedColValue = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        TestRunnable test = (partitioner, dir, bridge) -> {
            TestSchema schema = TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withColumn("b", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.aInt())).withTTL(ttlSecs).build();
            schema.writeSSTable(dir, bridge, partitioner, writer -> {
                for (int i = 0; i < rows; ++i) {
                    writer.write(new Object[]{i, expectedColValue});
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            });
            int t1 = navigatableTimeProvider.nowInSeconds();
            Assertions.assertThat((long)TestUtils.countSSTables(dir)).isEqualTo(1L);
            CqlTable table = schema.buildTable();
            TestDataLayer dataLayer = new TestDataLayer(bridge, TestUtils.getFileType(dir, FileType.DATA).collect(Collectors.toList()), table);
            BasicSupplier ssTableSupplier = new BasicSupplier(dataLayer.listSSTables().collect(Collectors.toSet()));
            int count = 0;
            referenceEpoch.set(t1 + timeOffsetSecs);
            try (StreamScanner scanner = bridge.getCompactionScanner(table, partitioner, (SSTablesSupplier)ssTableSupplier, null, Collections.emptyList(), SSTableTimeRangeFilter.ALL, null, navigatableTimeProvider, false, false, (Stats)Stats.DoNothingStats.INSTANCE);){
                RowData rowData = (RowData)scanner.data();
                while (scanner.next()) {
                    scanner.advanceToNextColumn();
                    ByteBuffer colBuf = rowData.getColumnName();
                    String colName = ByteBufferUtils.string((ByteBuffer)ByteBufferUtils.readBytesWithShortLength((ByteBuffer)colBuf));
                    colBuf.get();
                    if (StringUtils.isEmpty((String)colName)) continue;
                    Assertions.assertThat((String)colName).isEqualTo("b");
                    ByteBuffer b = rowData.getValue();
                    HashSet<Object> set = new HashSet<Object>(Arrays.asList(((GenericArrayData)bridge.set((CqlField.CqlType)bridge.aInt()).deserializeToType((TypeConverter)CassandraBridgeFactory.getSparkSql((CassandraBridge)bridge), b)).array()));
                    Assertions.assertThat(set).isEqualTo((Object)expectedColValue);
                    ++count;
                }
            }
            Assertions.assertThat((int)count).isEqualTo(expectedValues);
        };
        QuickTheory.qt().forAll(TestUtils.partitioners()).checkAssert(partitioner -> TestUtils.runTest(partitioner, bridgeForTest, test));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTimeRangeFilterSkipsSSTablesOutsideRange(CassandraBridge bridge) {
        long fiveDaysAgoMicros = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) - TimeUnit.DAYS.toMicros(5L);
        SSTableTimeRangeFilter excludingFilter = SSTableTimeRangeFilter.create((long)fiveDaysAgoMicros, (long)(fiveDaysAgoMicros + TimeUnit.DAYS.toMicros(1L)));
        this.testSSTableFiltering(bridge, excludingFilter, 0);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTimeRangeFilterIncludesSSTablesWithinRange(CassandraBridge bridge) {
        long fiveDaysAgoMicros = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()) - TimeUnit.DAYS.toMicros(5L);
        SSTableTimeRangeFilter includingFilter = SSTableTimeRangeFilter.create((long)fiveDaysAgoMicros, (long)(fiveDaysAgoMicros + TimeUnit.DAYS.toMicros(6L)));
        this.testSSTableFiltering(bridge, includingFilter, 10);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNoTimeRangeFilterReadsAllSSTables(CassandraBridge bridge) {
        this.testSSTableFiltering(bridge, SSTableTimeRangeFilter.ALL, 10);
    }

    private void testSSTableFiltering(CassandraBridge bridgeForTest, SSTableTimeRangeFilter filter, int expectedRowCount) {
        TestRunnable test = (partitioner, dir, bridgeInTest) -> {
            TestSchema schema = TestSchema.builder((CassandraBridge)bridgeInTest).withPartitionKey("a", (CqlField.CqlType)bridgeInTest.aInt()).withColumn("b", (CqlField.CqlType)bridgeInTest.aInt()).build();
            schema.writeSSTable(dir, bridgeInTest, partitioner, writer -> {
                for (int i = 0; i < 10; ++i) {
                    writer.write(new Object[]{i, i});
                }
            });
            Assertions.assertThat((long)TestUtils.countSSTables(dir)).isEqualTo(1L);
            CqlTable table = schema.buildTable();
            TestDataLayer dataLayer = new TestDataLayer(bridgeInTest, TestUtils.getFileType(dir, FileType.DATA).collect(Collectors.toList()), table);
            BasicSupplier ssTableSupplier = new BasicSupplier(dataLayer.listSSTables().collect(Collectors.toSet()));
            int rowCount = 0;
            try (StreamScanner scanner = bridgeInTest.getCompactionScanner(table, partitioner, (SSTablesSupplier)ssTableSupplier, null, Collections.emptyList(), filter, null, TimeProvider.DEFAULT, false, false, (Stats)Stats.DoNothingStats.INSTANCE);){
                RowData rowData = (RowData)scanner.data();
                while (scanner.next()) {
                    scanner.advanceToNextColumn();
                    ByteBuffer colBuf = rowData.getColumnName();
                    String colName = ByteBufferUtils.string((ByteBuffer)ByteBufferUtils.readBytesWithShortLength((ByteBuffer)colBuf));
                    colBuf.get();
                    if (StringUtils.isEmpty((String)colName)) continue;
                    ++rowCount;
                }
            }
            Assertions.assertThat((int)rowCount).isEqualTo(expectedRowCount);
        };
        QuickTheory.qt().forAll(TestUtils.partitioners()).checkAssert(partitioner -> TestUtils.runTest(partitioner, bridgeForTest, test));
    }
}

