/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="Sequential")
public class CompactionTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultipleSSTablesCompaction(CassandraBridge bridge) {
        AtomicLong startTotal = new AtomicLong(0L);
        AtomicLong newTotal = new AtomicLong(0L);
        HashMap column1 = new HashMap(200);
        HashMap column2 = new HashMap(200);
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.bigint()).withColumn("c2", (CqlField.CqlType)bridge.text())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < 200; ++row) {
                UUID pk = UUID.randomUUID();
                long c1 = RandomUtils.RANDOM.nextInt(10000000);
                String c2 = UUID.randomUUID().toString();
                startTotal.addAndGet(c1);
                column1.put(pk, c1);
                column2.put(pk, c2);
                writer.write(new Object[]{pk, c1, c2});
            }
        }).withSSTableWriter(writer -> {
            for (UUID pk : column1.keySet()) {
                long newBalance = (long)RandomUtils.RANDOM.nextInt(10000000) + (Long)column1.get(pk);
                Assertions.assertThat((long)newBalance).isGreaterThan((Comparable)((Long)column1.get(pk)));
                newTotal.addAndGet(newBalance);
                column1.put(pk, newBalance);
                writer.write(new Object[]{pk, newBalance, column2.get(pk)});
            }
        }).withCheck(dataset -> {
            Assertions.assertThat((long)startTotal.get()).isLessThan(newTotal.get());
            long sum = 0L;
            int count = 0;
            for (Row row : dataset.collectAsList()) {
                UUID pk = UUID.fromString(row.getString(0));
                Assertions.assertThat((long)row.getLong(1)).isEqualTo(((Long)column1.get(pk)).longValue());
                Assertions.assertThat((String)row.getString(2)).isEqualTo((String)column2.get(pk));
                sum += ((Long)row.get(1)).longValue();
                ++count;
            }
            Assertions.assertThat((int)count).isEqualTo(200);
            Assertions.assertThat((long)sum).isEqualTo(newTotal.get());
        }).withReset(() -> {
            startTotal.set(0L);
            newTotal.set(0L);
            column1.clear();
            column2.clear();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testCompaction(CassandraBridge bridge) {
        int numRowsColumns = 20;
        AtomicInteger total = new AtomicInteger(0);
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < numRowsColumns; ++row) {
                for (int column = 0; column < numRowsColumns; ++column) {
                    writer.write(new Object[]{row, column, 0});
                }
            }
        }).withSSTableWriter(writer -> {
            for (int row = 0; row < numRowsColumns; ++row) {
                for (int column = 0; column < numRowsColumns; ++column) {
                    writer.write(new Object[]{row, column, 1});
                }
            }
        }).withSSTableWriter(writer -> {
            for (int row = 0; row < numRowsColumns; ++row) {
                for (int column = 0; column < numRowsColumns; ++column) {
                    int num = column * 500;
                    total.addAndGet(num);
                    writer.write(new Object[]{row, column, num});
                }
            }
        }).withReadListener(row -> {
            assert (row.getInteger("b") * 500 == row.getInteger("c"));
        }).withCheck(dataset -> Assertions.assertThat((long)((Row)dataset.groupBy(new Column[0]).sum(new String[]{"c"}).first()).getLong(0)).isEqualTo((long)total.get())).withCheck(dataset -> Assertions.assertThat((long)((Row)dataset.groupBy(new Column[0]).count().first()).getLong(0)).isEqualTo((long)(numRowsColumns * numRowsColumns))).withReset(() -> total.set(0)).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSingleClusteringKey(CassandraBridge bridge) {
        AtomicLong total = new AtomicLong(0L);
        HashMap<Integer, MutableLong> testSum = new HashMap<Integer, MutableLong>();
        ImmutableSet clusteringKeys = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3);
        Iterator iterator = clusteringKeys.iterator();
        while (iterator.hasNext()) {
            int clusteringKey = (Integer)iterator.next();
            testSum.put(clusteringKey, new MutableLong(0L));
        }
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.bigint()).withColumn("d", (CqlField.CqlType)bridge.text())).dontWriteRandomData().withSSTableWriter(arg_0 -> CompactionTests.lambda$testSingleClusteringKey$11((Set)clusteringKeys, total, testSum, arg_0)).withExpectedRowCountPerSSTable(200 * clusteringKeys.size()).withCheck(arg_0 -> CompactionTests.lambda$testSingleClusteringKey$12(testSum, total, (Set)clusteringKeys, arg_0)).withCheck(dataset -> {
            for (Row row : dataset.groupBy("b", new String[0]).sum(new String[]{"c"}).collectAsList()) {
                Assertions.assertThat((long)row.getLong(1)).isEqualTo(((MutableLong)testSum.get(row.getInt(0))).getValue().longValue());
            }
        }).withReset(() -> CompactionTests.lambda$testSingleClusteringKey$14(total, (Set)clusteringKeys, testSum)).run(bridge.getVersion());
    }

    private static /* synthetic */ void lambda$testSingleClusteringKey$14(AtomicLong total, Set clusteringKeys, Map testSum) {
        total.set(0L);
        Iterator iterator = clusteringKeys.iterator();
        while (iterator.hasNext()) {
            int clusteringKey = (Integer)iterator.next();
            testSum.put(clusteringKey, new MutableLong(0L));
        }
    }

    private static /* synthetic */ void lambda$testSingleClusteringKey$12(Map testSum, AtomicLong total, Set clusteringKeys, Dataset dataset) {
        Assertions.assertThat((long)testSum.values().stream().mapToLong(MutableLong::getValue).sum()).isEqualTo(total.get());
        long sum = 0L;
        int count = 0;
        for (Row row : dataset.collectAsList()) {
            Assertions.assertThat((String)row.getString(0)).isNotNull();
            long balance = row.getLong(2);
            Assertions.assertThat((String)row.getString(3)).isNotNull();
            sum += balance;
            ++count;
        }
        Assertions.assertThat((long)sum).isEqualTo(total.get());
        Assertions.assertThat((int)count).isEqualTo(200 * clusteringKeys.size());
    }

    private static /* synthetic */ void lambda$testSingleClusteringKey$11(Set clusteringKeys, AtomicLong total, Map testSum, CassandraBridge.Writer writer) {
        for (int row = 0; row < 200; ++row) {
            Iterator iterator = clusteringKeys.iterator();
            while (iterator.hasNext()) {
                int clusteringKey = (Integer)iterator.next();
                UUID accountId = UUID.randomUUID();
                long balance = RandomUtils.RANDOM.nextInt(10000000);
                total.addAndGet(balance);
                String name = UUID.randomUUID().toString().substring(0, 8);
                ((MutableLong)testSum.get(clusteringKey)).add(balance);
                writer.write(new Object[]{accountId, clusteringKey, balance, name});
            }
        }
    }
}

