/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.CqlType;
import org.jetbrains.annotations.NotNull;

public class ColumnTypes {
    private ColumnTypes() {
    }

    public static ByteBuffer buildPartitionKey(@NotNull CqlTable table, @NotNull List<String> keys) {
        List<AbstractType<?>> partitionKeyColumnTypes = ColumnTypes.partitionKeyColumnTypes(table);
        if (table.partitionKeys().size() == 1) {
            return partitionKeyColumnTypes.get(0).fromString(keys.get(0));
        }
        Object[] buffers = new ByteBuffer[keys.size()];
        for (int index = 0; index < buffers.length; ++index) {
            buffers[index] = partitionKeyColumnTypes.get(index).fromString(keys.get(index));
        }
        return (ByteBuffer)CompositeType.build((ValueAccessor)ByteBufferAccessor.instance, (Object[])buffers);
    }

    @VisibleForTesting
    public static List<AbstractType<?>> partitionKeyColumnTypes(@NotNull CqlTable table) {
        return table.partitionKeys().stream().map(CqlField::type).map(type -> (CqlType)type).map(type -> type.dataType(true)).collect(Collectors.toList());
    }
}

