/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import net.openhft.affinity.CpuLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class VanillaCpuLayout
implements CpuLayout {
    public static final int MAX_CPUS_SUPPORTED = 256;
    @NotNull
    private final List<CpuInfo> cpuDetails;
    private final int sockets;
    private final int coresPerSocket;
    private final int threadsPerCore;

    VanillaCpuLayout(@NotNull List<CpuInfo> cpuDetails) {
        this.cpuDetails = cpuDetails;
        TreeSet<Integer> sockets = new TreeSet<Integer>();
        TreeSet<Integer> cores = new TreeSet<Integer>();
        TreeSet<Integer> threads = new TreeSet<Integer>();
        for (CpuInfo cpuDetail : cpuDetails) {
            sockets.add(cpuDetail.socketId);
            cores.add((cpuDetail.socketId << 16) + cpuDetail.coreId);
            threads.add(cpuDetail.threadId);
        }
        this.sockets = sockets.size();
        this.coresPerSocket = cores.size() / sockets.size();
        this.threadsPerCore = threads.size();
        if (cpuDetails.size() != this.sockets() * this.coresPerSocket() * this.threadsPerCore()) {
            StringBuilder error = new StringBuilder();
            error.append("cpuDetails.size= ").append(cpuDetails.size()).append(" != sockets: ").append(this.sockets()).append(" * coresPerSocket: ").append(this.coresPerSocket()).append(" * threadsPerCore: ").append(this.threadsPerCore()).append('\n');
            for (CpuInfo detail : cpuDetails) {
                error.append(detail).append('\n');
            }
            LoggerFactory.getLogger(VanillaCpuLayout.class).warn(error.toString());
        }
    }

    @NotNull
    public static VanillaCpuLayout fromProperties(String fileName) throws IOException {
        return VanillaCpuLayout.fromProperties(VanillaCpuLayout.openFile(fileName));
    }

    @NotNull
    public static VanillaCpuLayout fromProperties(InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        return VanillaCpuLayout.fromProperties(prop);
    }

    @NotNull
    public static VanillaCpuLayout fromProperties(@NotNull Properties prop) {
        String line;
        ArrayList<CpuInfo> cpuDetails = new ArrayList<CpuInfo>();
        for (int i = 0; i < 256 && (line = prop.getProperty("" + i)) != null; ++i) {
            String[] word = line.trim().split(" *, *");
            CpuInfo details = new CpuInfo(Integer.parseInt(word[0]), Integer.parseInt(word[1]), Integer.parseInt(word[2]));
            cpuDetails.add(details);
        }
        return new VanillaCpuLayout(cpuDetails);
    }

    @NotNull
    public static VanillaCpuLayout fromCpuInfo() throws IOException {
        return VanillaCpuLayout.fromCpuInfo("/proc/cpuinfo");
    }

    @NotNull
    public static VanillaCpuLayout fromCpuInfo(String filename) throws IOException {
        return VanillaCpuLayout.fromCpuInfo(VanillaCpuLayout.openFile(filename));
    }

    private static InputStream openFile(String filename) throws FileNotFoundException {
        try {
            return new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (is == null) {
                throw e;
            }
            return is;
        }
    }

    @NotNull
    public static VanillaCpuLayout fromCpuInfo(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        ArrayList<CpuInfo> cpuDetails = new ArrayList<CpuInfo>();
        CpuInfo details = new CpuInfo();
        LinkedHashMap<String, Integer> threadCount = new LinkedHashMap<String, Integer>();
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) {
                String key = details.socketId + "," + details.coreId;
                Integer count = (Integer)threadCount.get(key);
                if (count == null) {
                    count = 1;
                    threadCount.put(key, count);
                } else {
                    count = count + 1;
                    threadCount.put(key, count);
                }
                details.threadId = count - 1;
                cpuDetails.add(details);
                details = new CpuInfo();
                details.coreId = cpuDetails.size();
                continue;
            }
            String[] words = line.split("\\s*:\\s*", 2);
            if (words[0].equals("physical id")) {
                details.socketId = Integer.parseInt(words[1]);
                continue;
            }
            if (!words[0].equals("core id")) continue;
            details.coreId = Integer.parseInt(words[1]);
        }
        return new VanillaCpuLayout(cpuDetails);
    }

    @Override
    public int cpus() {
        return this.cpuDetails.size();
    }

    @Override
    public int sockets() {
        return this.sockets;
    }

    @Override
    public int coresPerSocket() {
        return this.coresPerSocket;
    }

    @Override
    public int threadsPerCore() {
        return this.threadsPerCore;
    }

    @Override
    public int socketId(int cpuId) {
        return this.cpuDetails.get((int)cpuId).socketId;
    }

    @Override
    public int coreId(int cpuId) {
        return this.cpuDetails.get((int)cpuId).coreId;
    }

    @Override
    public int threadId(int cpuId) {
        return this.cpuDetails.get((int)cpuId).threadId;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int cpuDetailsSize = this.cpuDetails.size();
        for (int i = 0; i < cpuDetailsSize; ++i) {
            CpuInfo cpuDetail = this.cpuDetails.get(i);
            sb.append(i).append(": ").append(cpuDetail).append('\n');
        }
        return sb.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaCpuLayout that = (VanillaCpuLayout)o;
        if (this.coresPerSocket != that.coresPerSocket) {
            return false;
        }
        if (this.sockets != that.sockets) {
            return false;
        }
        if (this.threadsPerCore != that.threadsPerCore) {
            return false;
        }
        return this.cpuDetails.equals(that.cpuDetails);
    }

    public int hashCode() {
        int result = this.cpuDetails.hashCode();
        result = 31 * result + this.sockets;
        result = 31 * result + this.coresPerSocket;
        result = 31 * result + this.threadsPerCore;
        return result;
    }

    static class CpuInfo {
        int socketId;
        int coreId;
        int threadId;

        CpuInfo() {
        }

        CpuInfo(int socketId, int coreId, int threadId) {
            this.socketId = socketId;
            this.coreId = coreId;
            this.threadId = threadId;
        }

        @NotNull
        public String toString() {
            return "CpuInfo{socketId=" + this.socketId + ", coreId=" + this.coreId + ", threadId=" + this.threadId + '}';
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CpuInfo cpuInfo = (CpuInfo)o;
            if (this.coreId != cpuInfo.coreId) {
                return false;
            }
            if (this.socketId != cpuInfo.socketId) {
                return false;
            }
            return this.threadId == cpuInfo.threadId;
        }

        public int hashCode() {
            int result = this.socketId;
            result = 31 * result + this.coreId;
            result = 31 * result + this.threadId;
            return result;
        }
    }
}

