/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.lockchecker;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.openhft.affinity.lockchecker.LockChecker;
import net.openhft.affinity.lockchecker.LockReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockBasedLockChecker
implements LockChecker {
    private static final int MAX_LOCK_RETRIES = 5;
    private static final ThreadLocal<SimpleDateFormat> dfTL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z"));
    private static final FileAttribute<Set<PosixFilePermission>> LOCK_FILE_ATTRIBUTES = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-rw-rw-"));
    private static final Set<OpenOption> LOCK_FILE_OPEN_OPTIONS = new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC));
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockBasedLockChecker.class);
    private static final FileLockBasedLockChecker instance = new FileLockBasedLockChecker();
    private final LockReference[] locks = new LockReference[256];

    protected FileLockBasedLockChecker() {
    }

    public static LockChecker getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isLockFree(int id) {
        if (this.locks[id] != null) {
            return false;
        }
        File lockFile = this.toFile(id);
        try {
            Throwable throwable = null;
            try (FileChannel channel = FileChannel.open(lockFile.toPath(), StandardOpenOption.READ);){
                boolean bl;
                Throwable throwable2;
                FileLock fileLock;
                block42: {
                    block43: {
                        block39: {
                            boolean bl2;
                            block40: {
                                block41: {
                                    fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
                                    throwable2 = null;
                                    if (fileLock == null || !fileLock.isValid()) break block39;
                                    if (!lockFile.delete()) {
                                        LOGGER.debug("Couldn't delete orphaned lock file " + lockFile);
                                    }
                                    bl2 = true;
                                    if (fileLock == null) break block40;
                                    if (throwable2 == null) break block41;
                                    try {
                                        fileLock.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block40;
                                }
                                fileLock.close();
                            }
                            return bl2;
                        }
                        bl = false;
                        if (fileLock == null) break block42;
                        if (throwable2 == null) break block43;
                        try {
                            fileLock.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        break block42;
                    }
                    fileLock.close();
                }
                return bl;
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (fileLock != null) {
                                    if (throwable2 != null) {
                                        try {
                                            fileLock.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                    } else {
                                        fileLock.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (OverlappingFileLockException e) {
                            boolean bl3 = false;
                            return bl3;
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        throw throwable9;
                    }
                }
            }
        }
        catch (NoSuchFileException e) {
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("An unexpected error occurred checking if the lock was free, assuming it's not", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized boolean obtainLock(int id, String metaInfo) throws IOException {
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                LockReference lockReference = this.tryAcquireLockOnFile(id, metaInfo);
                if (lockReference != null) {
                    this.locks[id] = lockReference;
                    return true;
                }
                return false;
            }
            catch (ConcurrentLockFileDeletionException e) {
                continue;
            }
        }
        LOGGER.warn("Exceeded maximum retries for locking CPU " + id + ", failing acquire");
        return false;
    }

    private LockReference tryAcquireLockOnFile(int id, String metaInfo) throws IOException, ConcurrentLockFileDeletionException {
        File lockFile = this.toFile(id);
        FileChannel fileChannel = FileChannel.open(lockFile.toPath(), LOCK_FILE_OPEN_OPTIONS, LOCK_FILE_ATTRIBUTES);
        try {
            FileLock fileLock = fileChannel.tryLock(0L, Long.MAX_VALUE, false);
            if (fileLock == null) {
                this.closeQuietly(fileChannel);
                return null;
            }
            if (!lockFile.exists()) {
                this.closeQuietly(fileLock, fileChannel);
                throw new ConcurrentLockFileDeletionException();
            }
            this.writeMetaInfoToFile(fileChannel, metaInfo);
            return new LockReference(fileChannel, fileLock);
        }
        catch (OverlappingFileLockException e) {
            this.closeQuietly(fileChannel);
            return null;
        }
    }

    private void writeMetaInfoToFile(FileChannel fc, String metaInfo) throws IOException {
        byte[] content = String.format("%s%n%s", metaInfo, dfTL.get().format(new Date())).getBytes();
        ByteBuffer buffer = ByteBuffer.wrap(content);
        while (buffer.hasRemaining()) {
            fc.write(buffer);
        }
    }

    @Override
    public synchronized boolean releaseLock(int id) {
        if (this.locks[id] != null) {
            File lockFile = this.toFile(id);
            if (!lockFile.delete()) {
                LOGGER.warn("Couldn't delete lock file on release: " + lockFile);
            }
            this.closeQuietly(this.locks[id].lock, this.locks[id].channel);
            this.locks[id] = null;
            return true;
        }
        return false;
    }

    private void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing " + closeable.getClass().getName(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMetaInfo(int id) throws IOException {
        File file = this.toFile(id);
        LockReference lr = this.locks[id];
        if (lr != null) {
            return this.readMetaInfoFromLockFileChannel(file, lr.channel);
        }
        try (FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            String string = this.readMetaInfoFromLockFileChannel(file, fc);
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    private String readMetaInfoFromLockFileChannel(File lockFile, FileChannel lockFileChannel) throws IOException {
        String content;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        int len = lockFileChannel.read(buffer, 0L);
        String string = content = len < 1 ? "" : new String(buffer.array(), 0, len);
        if (content.isEmpty()) {
            LOGGER.warn("Empty lock file {}", (Object)lockFile.getAbsolutePath());
            return null;
        }
        return content.substring(0, content.indexOf("\n"));
    }

    @NotNull
    protected File toFile(int id) {
        assert (id >= 0);
        return new File(this.tmpDir(), "cpu-" + id + ".lock");
    }

    private File tmpDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    class ConcurrentLockFileDeletionException
    extends Exception {
        ConcurrentLockFileDeletionException() {
        }
    }
}

