/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public enum GenericReflection {


    public static Set<Type> getMethodReturnTypes(Type type) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        if (type instanceof Class || type instanceof ParameterizedType) {
            for (Method method : GenericReflection.erase(type).getMethods()) {
                types.add(GenericReflection.getReturnType(method, type));
            }
            return types;
        }
        throw new UnsupportedOperationException();
    }

    public static Type getReturnType(Method method, Type type) {
        Type genericReturnType = method.getGenericReturnType();
        return GenericReflection.findType(method, type, genericReturnType);
    }

    @Nullable
    private static Type findType(Method method, Type type, Type genericReturnType) {
        if (genericReturnType instanceof Class) {
            return genericReturnType;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Optional<Type> extendsType = Stream.of(Stream.of(GenericReflection.getGenericSuperclass(type)), Stream.of(GenericReflection.getGenericInterfaces(type))).flatMap(s2 -> s2).filter(t2 -> declaringClass.equals(GenericReflection.erase(t2))).findFirst();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        if (extendsType.isPresent() && extendsType.get() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)extendsType.get();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!typeParameters[i].equals(genericReturnType)) continue;
                return actualTypeArguments[i];
            }
        }
        return genericReturnType;
    }

    public static Type[] getParameterTypes(Method method, Type type) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = GenericReflection.findType(method, type, parameterTypes[i]);
        }
        return parameterTypes;
    }

    static Type[] getGenericInterfaces(Type forClass) {
        if (forClass instanceof Class) {
            return ((Class)forClass).getGenericInterfaces();
        }
        if (forClass instanceof ParameterizedType) {
            return new Type[]{forClass};
        }
        throw new UnsupportedOperationException();
    }

    static Type getGenericSuperclass(Type forClass) {
        if (forClass instanceof Class) {
            return ((Class)forClass).getGenericSuperclass();
        }
        if (forClass instanceof ParameterizedType) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public static Class<?> erase(Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return GenericReflection.erase(tv.getBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            return GenericReflection.erase(((ParameterizedType)type).getRawType());
        }
        return (Class)type;
    }
}

