/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import org.jetbrains.annotations.NotNull;

public final class URIEncoder {
    private static final String MARK = "-_.!~*'()\"";
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    private URIEncoder() {
    }

    public static String encodeURI(@NotNull String argString) {
        @NotNull StringBuilder uri = new StringBuilder();
        for (char c : argString.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || MARK.indexOf(c) != -1) {
                uri.append(c);
                continue;
            }
            URIEncoder.appendEscaped(uri, c);
        }
        return uri.toString();
    }

    private static void appendEscaped(@NotNull StringBuilder uri, char c) {
        if (c <= '\u00ff') {
            uri.append("%");
            uri.append(HEX[c >> 4 & 0xF]);
            uri.append(HEX[c & 0xF]);
            return;
        }
        uri.append('\\');
        uri.append('u');
        uri.append(HEX[c >> 12 & 0xF]);
        uri.append(HEX[c >> 8 & 0xF]);
        uri.append(HEX[c >> 4 & 0xF]);
        uri.append(HEX[c & 0xF]);
    }
}

