/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.Interruptible;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteLoopExecutor
implements Interruptible {
    private static final Logger logger = LoggerFactory.getLogger(InfiniteLoopExecutor.class);
    private static final AtomicReferenceFieldUpdater<InfiniteLoopExecutor, Object> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(InfiniteLoopExecutor.class, Object.class, "state");
    private final Thread thread;
    private final Interruptible.Task task;
    private volatile Object state = Interruptible.State.NORMAL;
    private final Consumer<Thread> interruptHandler;
    private final Condition isTerminated = Condition.newOneTimeCondition();

    public InfiniteLoopExecutor(String name, Interruptible.Task task, Daemon daemon) {
        this(ExecutorFactory.Global.executorFactory(), name, task, daemon, Interrupts.UNSYNCHRONIZED);
    }

    public InfiniteLoopExecutor(ExecutorFactory factory, String name, Interruptible.Task task, Daemon daemon) {
        this(factory, name, task, daemon, Interrupts.UNSYNCHRONIZED);
    }

    public InfiniteLoopExecutor(ExecutorFactory factory, String name, Interruptible.Task task, Daemon daemon, Interrupts interrupts) {
        this.task = task;
        this.thread = factory.startThread(name, this::loop, daemon);
        this.interruptHandler = interrupts == Interrupts.SYNCHRONIZED ? InfiniteLoopExecutor.interruptHandler(task) : Thread::interrupt;
    }

    public InfiniteLoopExecutor(BiFunction<String, Runnable, Thread> threadStarter, String name, Interruptible.Task task, Interrupts interrupts) {
        this.task = task;
        this.thread = threadStarter.apply(name, this::loop);
        this.interruptHandler = interrupts == Interrupts.SYNCHRONIZED ? InfiniteLoopExecutor.interruptHandler(task) : Thread::interrupt;
    }

    private static Consumer<Thread> interruptHandler(Object monitor) {
        return thread -> {
            Object object = monitor;
            synchronized (object) {
                thread.interrupt();
            }
        };
    }

    private void loop() {
        block11: {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        Object cur;
                        do {
                            if ((cur = this.state) == InternalState.SHUTTING_DOWN_NOW) {
                                break block11;
                            }
                            if (cur == Interruptible.State.NORMAL && (interrupted |= Thread.interrupted())) {
                                cur = Interruptible.State.INTERRUPTED;
                            }
                            this.task.run((Interruptible.State)((Object)cur));
                            interrupted = false;
                        } while (cur != Interruptible.State.SHUTTING_DOWN);
                    }
                    catch (Interruptible.TerminateException ignore) {
                    }
                    catch (InterruptedException | UncheckedInterruptedException ignore) {
                        interrupted = true;
                        continue;
                    }
                    catch (Throwable t2) {
                        logger.error("Exception thrown by runnable, continuing with loop", t2);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.state = InternalState.TERMINATED;
                this.isTerminated.signal();
            }
        }
    }

    @Override
    public void interrupt() {
        this.interruptHandler.accept(this.thread);
    }

    @Override
    public void shutdown() {
        stateUpdater.updateAndGet(this, cur -> cur != InternalState.TERMINATED && cur != InternalState.SHUTTING_DOWN_NOW ? Interruptible.State.SHUTTING_DOWN : cur);
        this.interruptHandler.accept(this.thread);
    }

    @Override
    public Object shutdownNow() {
        stateUpdater.updateAndGet(this, cur -> cur != InternalState.TERMINATED ? InternalState.SHUTTING_DOWN_NOW : InternalState.TERMINATED);
        this.interruptHandler.accept(this.thread);
        return null;
    }

    @Override
    public boolean isTerminated() {
        return this.state == InternalState.TERMINATED;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        if (this.isTerminated()) {
            return true;
        }
        long deadlineNanos = Clock.Global.nanoTime() + unit.toNanos(time);
        this.isTerminated.awaitUntil(deadlineNanos);
        return this.isTerminated();
    }

    @VisibleForTesting
    public boolean isAlive() {
        return this.thread.isAlive();
    }

    @Shared(scope={Shared.Scope.SIMULATION})
    public static enum Interrupts {
        SYNCHRONIZED,
        UNSYNCHRONIZED;

    }

    @Shared(scope={Shared.Scope.SIMULATION})
    public static enum Daemon {
        DAEMON,
        NON_DAEMON;

    }

    @Shared(scope={Shared.Scope.SIMULATION})
    public static enum SimulatorSafe {
        SAFE,
        UNSAFE;

    }

    @Shared(scope={Shared.Scope.SIMULATION})
    public static enum InternalState {
        SHUTTING_DOWN_NOW,
        TERMINATED;

    }
}

