/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.gms.GossipShutdown;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipShutdownVerbHandler
implements IVerbHandler<GossipShutdown> {
    public static final GossipShutdownVerbHandler instance = new GossipShutdownVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(GossipShutdownVerbHandler.class);

    @Override
    public void doVerb(Message<GossipShutdown> message) {
        if (!Gossiper.instance.isEnabled()) {
            logger.debug("Ignoring shutdown message from {} because gossip is disabled", (Object)message.from());
            return;
        }
        HeartBeatState previous = Gossiper.instance.getEndpointStateForEndpoint(message.from()).getHeartBeatState();
        if (message.payload == null) {
            Gossiper.instance.markAsShutdown(message.from());
        } else if (previous.getGeneration() <= ((GossipShutdown)message.payload).state.getHeartBeatState().getGeneration()) {
            Gossiper.instance.markAsShutdown(message.from(), ((GossipShutdown)message.payload).state);
        } else {
            logger.debug("Ignoring shutdown message from {} because generation {} older than local {}", new Object[]{message.from(), ((GossipShutdown)message.payload).state.getHeartBeatState().getGeneration(), previous.getGeneration()});
        }
    }
}

