/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;

public class ResettableByteBuffersIndexOutput
extends IndexOutput {
    private final ByteBuffersIndexOutput bbio;
    private final ByteBuffersDataOutput delegate;

    public ResettableByteBuffersIndexOutput(String name) {
        this(128, name);
    }

    public ResettableByteBuffersIndexOutput(int expectedSize, String name) {
        super("", name);
        this.delegate = new ByteBuffersDataOutput(expectedSize);
        this.bbio = new ByteBuffersIndexOutput(this.delegate, "", name + "-bb");
    }

    public void copyTo(IndexOutput out) throws IOException {
        this.delegate.copyTo(out);
    }

    public int intSize() {
        return Math.toIntExact(this.bbio.getFilePointer());
    }

    public byte[] toArrayCopy() {
        return this.delegate.toArrayCopy();
    }

    public void reset() {
        this.delegate.reset();
    }

    @Override
    public String toString() {
        return "Resettable" + this.bbio.toString();
    }

    @Override
    public void close() throws IOException {
        this.bbio.close();
    }

    @Override
    public long getFilePointer() {
        return this.bbio.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.bbio.getChecksum();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.bbio.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.bbio.writeBytes(b, offset, length);
    }

    @Override
    public void writeBytes(byte[] b, int length) throws IOException {
        this.bbio.writeBytes(b, length);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.bbio.writeInt(i);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.bbio.writeShort(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.bbio.writeLong(i);
    }

    @Override
    public void writeString(String s2) throws IOException {
        this.bbio.writeString(s2);
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.bbio.copyBytes(input, numBytes);
    }

    @Override
    public void writeMapOfStrings(Map<String, String> map) throws IOException {
        this.bbio.writeMapOfStrings(map);
    }

    @Override
    public void writeSetOfStrings(Set<String> set) throws IOException {
        this.bbio.writeSetOfStrings(set);
    }
}

