/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import org.apache.cassandra.index.sai.disk.v1.vector.RamAwareVectorValues;
import org.apache.cassandra.index.sai.disk.v1.vector.RamEstimation;
import org.jctools.maps.NonBlockingHashMapLong;

public class ConcurrentVectorValues
implements RamAwareVectorValues {
    private final int dimensions;
    private final NonBlockingHashMapLong<float[]> values = new NonBlockingHashMapLong();

    public ConcurrentVectorValues(int dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int dimension() {
        return this.dimensions;
    }

    @Override
    public float[] vectorValue(int i) {
        return this.values.get(i);
    }

    public long add(int ordinal, float[] vector) {
        this.values.put(ordinal, vector);
        return RamEstimation.concurrentHashMapRamUsed(1) + this.oneVectorBytesUsed();
    }

    @Override
    public boolean isValueShared() {
        return false;
    }

    public ConcurrentVectorValues copy() {
        return this;
    }

    private long oneVectorBytesUsed() {
        return 8L + (long)this.dimension() * 4L;
    }
}

