/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public interface PrimaryKey
extends Comparable<PrimaryKey>,
ByteComparable {
    public Kind kind();

    public Token token();

    public DecoratedKey partitionKey();

    public Clustering<?> clustering();

    @Override
    public ByteSource asComparableBytes(ByteComparable.Version var1);

    default public PrimaryKey toStatic() {
        throw new UnsupportedOperationException("Only STATIC and WIDE keys can be converted to STATIC");
    }

    default public int compareTo(PrimaryKey key, boolean strict) {
        return this.compareTo(key);
    }

    public boolean equals(Object var1, boolean var2);

    public static class Factory {
        private final IPartitioner partitioner;
        private final ClusteringComparator clusteringComparator;

        public Factory(IPartitioner partitioner, ClusteringComparator clusteringComparator) {
            this.partitioner = partitioner;
            this.clusteringComparator = clusteringComparator;
        }

        public PrimaryKey create(Token token) {
            assert (token != null) : "Cannot create a primary key with a null token";
            return new TokenOnlyPrimaryKey(token);
        }

        public PrimaryKey create(DecoratedKey partitionKey) {
            assert (this.clusteringComparator.size() == 0) : "Cannot create a skinny primary key for a table with clustering columns";
            assert (partitionKey != null) : "Cannot create a primary key with a null partition key";
            return new SkinnyPrimaryKey(partitionKey);
        }

        public PrimaryKey create(DecoratedKey partitionKey, Clustering<?> clustering) {
            assert (this.clusteringComparator.size() > 0) : "Cannot create a wide primary key for a table without clustering columns";
            assert (partitionKey != null) : "Cannot create a primary key with a null partition key";
            assert (clustering != null) : "Cannot create a primary key with a null clustering";
            return clustering == Clustering.STATIC_CLUSTERING ? new StaticPrimaryKey(partitionKey) : new WidePrimaryKey(partitionKey, clustering);
        }

        public boolean hasClusteringColumns() {
            return this.clusteringComparator != null && this.clusteringComparator.size() > 0;
        }

        public PrimaryKey fromComparableBytes(ByteSource byteSource) {
            if (this.clusteringComparator.size() > 0) {
                ByteSource.Peekable peekable = ByteSource.peekable(byteSource);
                DecoratedKey partitionKey = this.partitionKeyFromComparableBytes(ByteSourceInverse.nextComponentSource(peekable));
                Clustering<?> clustering = this.clusteringFromByteComparable(ByteSourceInverse.nextComponentSource(peekable));
                return this.create(partitionKey, clustering);
            }
            return this.create(this.partitionKeyFromComparableBytes(byteSource));
        }

        public DecoratedKey partitionKeyFromComparableBytes(ByteSource byteSource) {
            ByteBuffer decoratedKey = ByteBuffer.wrap(ByteSourceInverse.getUnescapedBytes(ByteSource.peekable(byteSource)));
            return new BufferDecoratedKey(this.partitioner.getToken(decoratedKey), decoratedKey);
        }

        public Clustering<?> clusteringFromByteComparable(ByteSource byteSource) {
            Clustering<ByteBuffer> clustering = this.clusteringComparator.clusteringFromByteComparable(ByteBufferAccessor.instance, v -> byteSource);
            return clustering == null ? Clustering.STATIC_CLUSTERING : clustering;
        }

        class WidePrimaryKey
        extends SkinnyPrimaryKey {
            private final Clustering<?> clustering;

            WidePrimaryKey(DecoratedKey partitionKey, Clustering<?> clustering) {
                super(partitionKey);
                this.clustering = clustering;
            }

            @Override
            public Kind kind() {
                return Kind.WIDE;
            }

            @Override
            public Clustering<?> clustering() {
                return this.clustering;
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                ByteSource keyComparable = ByteSource.of(this.partitionKey().getKey(), version);
                ByteSource clusteringComparable = Factory.this.clusteringComparator.asByteComparable(this.clustering()).asComparableBytes(version);
                return ByteSource.withTerminator(version == ByteComparable.Version.LEGACY ? -1 : 56, keyComparable, clusteringComparable);
            }

            @Override
            public int compareTo(PrimaryKey o, boolean strict) {
                int cmp = super.compareTo(o);
                if (cmp != 0 || o.kind() == Kind.TOKEN || o.kind() == Kind.SKINNY) {
                    return cmp;
                }
                if (o.kind() == Kind.STATIC) {
                    return strict ? 1 : 0;
                }
                return Factory.this.clusteringComparator.compare(this.clustering(), o.clustering());
            }

            @Override
            public int compareTo(PrimaryKey o) {
                return this.compareTo(o, true);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.token(), this.partitionKey(), this.clustering(), Factory.this.clusteringComparator);
            }

            @Override
            public String toString() {
                return String.format("PrimaryKey: { token: %s, partition: %s, clustering: %s:%s } ", new Object[]{this.token(), this.partitionKey(), this.clustering().kind(), Arrays.stream(this.clustering().getBufferArray()).map(ByteBufferUtil::bytesToHex).collect(Collectors.joining(", "))});
            }

            @Override
            public PrimaryKey toStatic() {
                return new StaticPrimaryKey(this.partitionKey);
            }
        }

        class StaticPrimaryKey
        extends SkinnyPrimaryKey {
            StaticPrimaryKey(DecoratedKey partitionKey) {
                super(partitionKey);
            }

            @Override
            public Kind kind() {
                return Kind.STATIC;
            }

            @Override
            public Clustering<?> clustering() {
                return Clustering.STATIC_CLUSTERING;
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                ByteSource keyComparable = ByteSource.of(this.partitionKey().getKey(), version);
                return ByteSource.withTerminator(version == ByteComparable.Version.LEGACY ? -1 : 56, keyComparable, null);
            }

            @Override
            public int compareTo(PrimaryKey o, boolean strict) {
                int cmp = super.compareTo(o);
                if (cmp != 0 || o.kind() == Kind.TOKEN || o.kind() == Kind.SKINNY) {
                    return cmp;
                }
                if (strict && o.kind() == Kind.WIDE) {
                    return -1;
                }
                return 0;
            }

            @Override
            public int compareTo(PrimaryKey o) {
                return this.compareTo(o, true);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.token(), this.partitionKey(), Clustering.STATIC_CLUSTERING, Factory.this.clusteringComparator);
            }

            @Override
            public String toString() {
                return String.format("PrimaryKey: { token: %s, partition: %s, clustering: STATIC } ", this.token(), this.partitionKey());
            }

            @Override
            public PrimaryKey toStatic() {
                return this;
            }
        }

        class SkinnyPrimaryKey
        extends TokenOnlyPrimaryKey {
            protected final DecoratedKey partitionKey;

            SkinnyPrimaryKey(DecoratedKey partitionKey) {
                super(partitionKey.getToken());
                this.partitionKey = partitionKey;
            }

            @Override
            public Kind kind() {
                return Kind.SKINNY;
            }

            @Override
            public DecoratedKey partitionKey() {
                return this.partitionKey;
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                return ByteSource.of(this.partitionKey().getKey(), version);
            }

            @Override
            public int compareTo(PrimaryKey o) {
                int cmp = super.compareTo(o);
                if (cmp != 0 || o.kind() == Kind.TOKEN) {
                    return cmp;
                }
                return this.partitionKey().compareTo(o.partitionKey());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.token(), this.partitionKey(), Clustering.EMPTY, Factory.this.clusteringComparator);
            }

            @Override
            public String toString() {
                return String.format("PrimaryKey: { token: %s, partition: %s }", this.token(), this.partitionKey());
            }
        }

        class TokenOnlyPrimaryKey
        implements PrimaryKey {
            protected final Token token;

            TokenOnlyPrimaryKey(Token token) {
                this.token = token;
            }

            @Override
            public Kind kind() {
                return Kind.TOKEN;
            }

            @Override
            public Token token() {
                return this.token;
            }

            @Override
            public DecoratedKey partitionKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Clustering<?> clustering() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(PrimaryKey o) {
                return this.token().compareTo(o.token());
            }

            public int hashCode() {
                return Objects.hash(this.token(), Factory.this.clusteringComparator);
            }

            public boolean equals(Object o) {
                if (o instanceof PrimaryKey) {
                    return this.compareTo((PrimaryKey)o) == 0;
                }
                return false;
            }

            @Override
            public boolean equals(Object o, boolean strict) {
                if (o == null) {
                    return false;
                }
                if (o instanceof PrimaryKey) {
                    return this.compareTo((PrimaryKey)o, strict) == 0;
                }
                return false;
            }

            public String toString() {
                return String.format("PrimaryKey: { token: %s }", this.token());
            }
        }
    }

    public static enum Kind {
        TOKEN(false),
        SKINNY(false),
        WIDE(true),
        STATIC(true);

        public final boolean hasClustering;

        private Kind(boolean hasClustering) {
            this.hasClustering = hasClustering;
        }

        public boolean isIntersectable(Kind other) {
            if (this == TOKEN) {
                return other == TOKEN;
            }
            if (this == SKINNY) {
                return other == SKINNY;
            }
            if (this == WIDE || this == STATIC) {
                return other == WIDE || other == STATIC;
            }
            throw new AssertionError((Object)("Unknown Kind: " + other));
        }
    }
}

