/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils.trie;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.cassandra.index.sasi.utils.trie.AbstractTrie;
import org.apache.cassandra.index.sasi.utils.trie.Cursor;
import org.apache.cassandra.index.sasi.utils.trie.KeyAnalyzer;
import org.apache.cassandra.index.sasi.utils.trie.Tries;

abstract class AbstractPatriciaTrie<K, V>
extends AbstractTrie<K, V> {
    private static final long serialVersionUID = -2303909182832019043L;
    final TrieEntry<K, V> root = new TrieEntry<Object, Object>(null, null, -1);
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private int size = 0;
    transient int modCount = 0;

    public AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        super(keyAnalyzer);
    }

    public AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer, Map<? extends K, ? extends V> m4) {
        super(keyAnalyzer);
        this.putAll(m4);
    }

    @Override
    public void clear() {
        this.root.key = null;
        this.root.bitIndex = -1;
        this.root.value = null;
        this.root.parent = null;
        this.root.left = this.root;
        this.root.right = null;
        this.root.predecessor = this.root;
        this.size = 0;
        this.incrementModCount();
    }

    @Override
    public int size() {
        return this.size;
    }

    void incrementSize() {
        ++this.size;
        this.incrementModCount();
    }

    void decrementSize() {
        --this.size;
        this.incrementModCount();
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return this.root.setKeyValue(key, value);
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key);
        if (this.compareKeys(key, found.key)) {
            if (found.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return found.setKeyValue(key, value);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (!Tries.isOutOfBoundsIndex(bitIndex)) {
            if (Tries.isValidBitIndex(bitIndex)) {
                TrieEntry<K, V> t2 = new TrieEntry<K, V>(key, value, bitIndex);
                this.addEntry(t2);
                this.incrementSize();
                return null;
            }
            if (Tries.isNullBitKey(bitIndex)) {
                if (this.root.isEmpty()) {
                    this.incrementSize();
                } else {
                    this.incrementModCount();
                }
                return this.root.setKeyValue(key, value);
            }
            if (Tries.isEqualBitKey(bitIndex) && found != this.root) {
                this.incrementModCount();
                return found.setKeyValue(key, value);
            }
        }
        throw new IndexOutOfBoundsException("Failed to put: " + key + " -> " + value + ", " + bitIndex);
    }

    TrieEntry<K, V> addEntry(TrieEntry<K, V> entry) {
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (true) {
            if (current.bitIndex >= entry.bitIndex || current.bitIndex <= path.bitIndex) {
                entry.predecessor = entry;
                if (!this.isBitSet(entry.key, entry.bitIndex)) {
                    entry.left = entry;
                    entry.right = current;
                } else {
                    entry.left = current;
                    entry.right = entry;
                }
                entry.parent = path;
                if (current.bitIndex >= entry.bitIndex) {
                    current.parent = entry;
                }
                if (current.bitIndex <= path.bitIndex) {
                    current.predecessor = entry;
                }
                if (path == this.root || !this.isBitSet(entry.key, path.bitIndex)) {
                    path.left = entry;
                } else {
                    path.right = entry;
                }
                return entry;
            }
            path = current;
            current = !this.isBitSet(entry.key, current.bitIndex) ? current.left : current.right;
        }
    }

    @Override
    public V get(Object k) {
        TrieEntry<K, V> entry = this.getEntry(k);
        return entry != null ? (V)entry.getValue() : null;
    }

    TrieEntry<K, V> getEntry(Object k) {
        Object key = Tries.cast(k);
        if (key == null) {
            return null;
        }
        TrieEntry entry = this.getNearestEntryForKey(key);
        return !entry.isEmpty() && this.compareKeys(key, entry.key) ? entry : null;
    }

    @Override
    public Map.Entry<K, V> select(K key) {
        Reference<Map.Entry<K, V>> reference = new Reference<Map.Entry<K, V>>();
        return !this.selectR(this.root.left, -1, key, reference) ? reference.get() : null;
    }

    @Override
    public Map.Entry<K, V> select(K key, Cursor<? super K, ? super V> cursor) {
        Reference<Map.Entry<K, V>> reference = new Reference<Map.Entry<K, V>>();
        this.selectR(this.root.left, -1, key, cursor, reference);
        return reference.get();
    }

    private boolean selectR(TrieEntry<K, V> h2, int bitIndex, K key, Reference<Map.Entry<K, V>> reference) {
        if (h2.bitIndex <= bitIndex) {
            if (!h2.isEmpty()) {
                reference.set(h2);
                return false;
            }
            return true;
        }
        if (!this.isBitSet(key, h2.bitIndex)) {
            if (this.selectR(h2.left, h2.bitIndex, key, reference)) {
                return this.selectR(h2.right, h2.bitIndex, key, reference);
            }
        } else if (this.selectR(h2.right, h2.bitIndex, key, reference)) {
            return this.selectR(h2.left, h2.bitIndex, key, reference);
        }
        return false;
    }

    private boolean selectR(TrieEntry<K, V> h2, int bitIndex, K key, Cursor<? super K, ? super V> cursor, Reference<Map.Entry<K, V>> reference) {
        if (h2.bitIndex <= bitIndex) {
            if (!h2.isEmpty()) {
                Cursor.Decision decision = cursor.select(h2);
                switch (decision) {
                    case REMOVE: {
                        throw new UnsupportedOperationException("Cannot remove during select");
                    }
                    case EXIT: {
                        reference.set(h2);
                        return false;
                    }
                    case REMOVE_AND_EXIT: {
                        TrieEntry entry = new TrieEntry(h2.getKey(), h2.getValue(), -1);
                        reference.set(entry);
                        this.removeEntry(h2);
                        return false;
                    }
                }
            }
            return true;
        }
        if (!this.isBitSet(key, h2.bitIndex)) {
            if (this.selectR(h2.left, h2.bitIndex, key, cursor, reference)) {
                return this.selectR(h2.right, h2.bitIndex, key, cursor, reference);
            }
        } else if (this.selectR(h2.right, h2.bitIndex, key, cursor, reference)) {
            return this.selectR(h2.left, h2.bitIndex, key, cursor, reference);
        }
        return false;
    }

    @Override
    public Map.Entry<K, V> traverse(Cursor<? super K, ? super V> cursor) {
        TrieEntry<K, V> entry = this.nextEntry(null);
        while (entry != null) {
            TrieEntry<K, V> current = entry;
            Cursor.Decision decision = cursor.select(current);
            entry = this.nextEntry(current);
            switch (decision) {
                case EXIT: {
                    return current;
                }
                case REMOVE: {
                    this.removeEntry(current);
                    break;
                }
                case REMOVE_AND_EXIT: {
                    TrieEntry value = new TrieEntry(current.getKey(), current.getValue(), -1);
                    this.removeEntry(current);
                    return value;
                }
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object k) {
        if (k == null) {
            return false;
        }
        Object key = Tries.cast(k);
        TrieEntry entry = this.getNearestEntryForKey(key);
        return !entry.isEmpty() && this.compareKeys(key, entry.key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public V remove(Object k) {
        if (k == null) {
            return null;
        }
        Object key = Tries.cast(k);
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (true) {
            if (current.bitIndex <= path.bitIndex) {
                if (!current.isEmpty() && this.compareKeys(key, current.key)) {
                    return this.removeEntry(current);
                }
                return null;
            }
            path = current;
            current = !this.isBitSet(key, current.bitIndex) ? current.left : current.right;
        }
    }

    TrieEntry<K, V> getNearestEntryForKey(K key) {
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (current.bitIndex > path.bitIndex) {
            path = current;
            current = !this.isBitSet(key, current.bitIndex) ? current.left : current.right;
        }
        return current;
    }

    V removeEntry(TrieEntry<K, V> h2) {
        if (h2 != this.root) {
            if (h2.isInternalNode()) {
                this.removeInternalEntry(h2);
            } else {
                this.removeExternalEntry(h2);
            }
        }
        this.decrementSize();
        return h2.setKeyValue(null, null);
    }

    private void removeExternalEntry(TrieEntry<K, V> h2) {
        TrieEntry child;
        if (h2 == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h2.isExternalNode()) {
            throw new IllegalArgumentException(h2 + " is not an external Entry!");
        }
        TrieEntry parent = h2.parent;
        TrieEntry trieEntry = child = h2.left == h2 ? h2.right : h2.left;
        if (parent.left == h2) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        } else {
            child.predecessor = parent;
        }
    }

    private void removeInternalEntry(TrieEntry<K, V> h2) {
        TrieEntry child;
        if (h2 == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h2.isInternalNode()) {
            throw new IllegalArgumentException(h2 + " is not an internal Entry!");
        }
        TrieEntry p = h2.predecessor;
        p.bitIndex = h2.bitIndex;
        TrieEntry parent = p.parent;
        TrieEntry trieEntry = child = p.left == h2 ? p.right : p.left;
        if (p.predecessor == p && p.parent != h2) {
            p.predecessor = p.parent;
        }
        if (parent.left == p) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        }
        if (h2.left.parent == h2) {
            h2.left.parent = p;
        }
        if (h2.right.parent == h2) {
            h2.right.parent = p;
        }
        if (h2.parent.left == h2) {
            h2.parent.left = p;
        } else {
            h2.parent.right = p;
        }
        p.parent = h2.parent;
        p.left = h2.left;
        p.right = h2.right;
        if (AbstractPatriciaTrie.isValidUplink(p.left, p)) {
            p.left.predecessor = p;
        }
        if (AbstractPatriciaTrie.isValidUplink(p.right, p)) {
            p.right.predecessor = p;
        }
    }

    TrieEntry<K, V> nextEntry(TrieEntry<K, V> node) {
        return node == null ? this.firstEntry() : this.nextEntryImpl(node.predecessor, node, null);
    }

    TrieEntry<K, V> nextEntryImpl(TrieEntry<K, V> start, TrieEntry<K, V> previous, TrieEntry<K, V> tree) {
        TrieEntry<K, V> current = start;
        if (previous == null || start != previous.predecessor) {
            while (!current.left.isEmpty() && previous != current.left) {
                if (AbstractPatriciaTrie.isValidUplink(current.left, current)) {
                    return current.left;
                }
                current = current.left;
            }
        }
        if (current.isEmpty()) {
            return null;
        }
        if (current.right == null) {
            return null;
        }
        if (previous != current.right) {
            if (AbstractPatriciaTrie.isValidUplink(current.right, current)) {
                return current.right;
            }
            return this.nextEntryImpl(current.right, previous, tree);
        }
        while (current == current.parent.right) {
            if (current == tree) {
                return null;
            }
            current = current.parent;
        }
        if (current == tree) {
            return null;
        }
        if (current.parent.right == null) {
            return null;
        }
        if (previous != current.parent.right && AbstractPatriciaTrie.isValidUplink(current.parent.right, current.parent)) {
            return current.parent.right;
        }
        if (current.parent.right == current.parent) {
            return null;
        }
        return this.nextEntryImpl(current.parent.right, previous, tree);
    }

    @Override
    TrieEntry<K, V> firstEntry() {
        return this.isEmpty() ? null : this.followLeft(this.root);
    }

    TrieEntry<K, V> followLeft(TrieEntry<K, V> node) {
        while (true) {
            TrieEntry child;
            if ((child = node.left).isEmpty()) {
                child = node.right;
            }
            if (child.bitIndex <= node.bitIndex) {
                return child;
            }
            node = child;
        }
    }

    static boolean isValidUplink(TrieEntry<?, ?> next, TrieEntry<?, ?> from) {
        return next != null && next.bitIndex <= from.bitIndex && !next.isEmpty();
    }

    abstract class TrieIterator<E>
    implements Iterator<E> {
        protected int expectedModCount;
        protected TrieEntry<K, V> next;
        protected TrieEntry<K, V> current;

        protected TrieIterator() {
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
            this.next = AbstractPatriciaTrie.this.nextEntry(null);
        }

        protected TrieIterator(TrieEntry<K, V> firstEntry) {
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
            this.next = firstEntry;
        }

        protected TrieEntry<K, V> nextEntry() {
            if (this.expectedModCount != AbstractPatriciaTrie.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(e);
            this.current = e;
            return e;
        }

        protected TrieEntry<K, V> findNext(TrieEntry<K, V> prior) {
            return AbstractPatriciaTrie.this.nextEntry(prior);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCount != AbstractPatriciaTrie.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry node = this.current;
            this.current = null;
            AbstractPatriciaTrie.this.removeEntry(node);
            this.expectedModCount = AbstractPatriciaTrie.this.modCount;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractPatriciaTrie.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                if (!Tries.areEqual(value, o)) continue;
                it.remove();
                return true;
            }
            return false;
        }

        private class ValueIterator
        extends TrieIterator<V> {
            private ValueIterator() {
            }

            @Override
            public V next() {
                return this.nextEntry().getValue();
            }
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractPatriciaTrie.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            AbstractPatriciaTrie.this.remove(o);
            return size != this.size();
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        private class KeyIterator
        extends TrieIterator<K> {
            private KeyIterator() {
            }

            @Override
            public K next() {
                return this.nextEntry().getKey();
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            TrieEntry candidate = AbstractPatriciaTrie.this.getEntry(((Map.Entry)o).getKey());
            return candidate != null && candidate.equals(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            AbstractPatriciaTrie.this.remove(o);
            return size != this.size();
        }

        @Override
        public int size() {
            return AbstractPatriciaTrie.this.size();
        }

        @Override
        public void clear() {
            AbstractPatriciaTrie.this.clear();
        }

        private class EntryIterator
        extends TrieIterator<Map.Entry<K, V>> {
            private EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }
    }

    static class TrieEntry<K, V>
    extends AbstractTrie.BasicEntry<K, V> {
        private static final long serialVersionUID = 4596023148184140013L;
        protected int bitIndex;
        protected TrieEntry<K, V> parent;
        protected TrieEntry<K, V> left;
        protected TrieEntry<K, V> right;
        protected TrieEntry<K, V> predecessor;

        public TrieEntry(K key, V value, int bitIndex) {
            super(key, value);
            this.bitIndex = bitIndex;
            this.parent = null;
            this.left = this;
            this.right = null;
            this.predecessor = this;
        }

        public boolean isEmpty() {
            return this.key == null;
        }

        public boolean isInternalNode() {
            return this.left != this && this.right != this;
        }

        public boolean isExternalNode() {
            return !this.isInternalNode();
        }
    }

    private static class Reference<E> {
        private E item;

        private Reference() {
        }

        public void set(E item) {
            this.item = item;
        }

        public E get() {
            return this.item;
        }
    }
}

