/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.keycache;

import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCache {
    public static final KeyCache NO_CACHE = new KeyCache(null);
    private static final Logger logger = LoggerFactory.getLogger(KeyCache.class);
    private final InstrumentingCache<KeyCacheKey, AbstractRowIndexEntry> cache;
    private final LongAdder hits = new LongAdder();
    private final LongAdder requests = new LongAdder();

    public KeyCache(@Nullable InstrumentingCache<KeyCacheKey, AbstractRowIndexEntry> cache) {
        this.cache = cache;
    }

    public long getHits() {
        return this.cache != null ? this.hits.sum() : 0L;
    }

    public long getRequests() {
        return this.cache != null ? this.requests.sum() : 0L;
    }

    public void put(@Nonnull KeyCacheKey cacheKey, @Nonnull AbstractRowIndexEntry info) {
        if (this.cache == null) {
            return;
        }
        logger.trace("Adding cache entry for {} -> {}", (Object)cacheKey, (Object)info);
        this.cache.put(cacheKey, info);
    }

    @Nullable
    public AbstractRowIndexEntry get(KeyCacheKey key, boolean updateStats) {
        if (this.cache == null) {
            return null;
        }
        if (updateStats) {
            this.requests.increment();
            AbstractRowIndexEntry r = this.cache.get(key);
            if (r != null) {
                this.hits.increment();
            }
            return r;
        }
        return this.cache.getInternal(key);
    }

    public boolean isEnabled() {
        return this.cache != null;
    }
}

