/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import org.apache.cassandra.utils.concurrent.AsyncPromise;

public class AsyncChannelPromise
extends AsyncPromise.WithExecutor<Void>
implements ChannelPromise {
    private final Channel channel;

    public AsyncChannelPromise(Channel channel) {
        super(channel.eventLoop());
        this.channel = channel;
    }

    AsyncChannelPromise(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        super((Executor)channel.eventLoop(), listener);
        this.channel = channel;
    }

    public static AsyncChannelPromise withListener(ChannelHandlerContext context, GenericFutureListener<? extends Future<? super Void>> listener) {
        return AsyncChannelPromise.withListener(context.channel(), listener);
    }

    public static AsyncChannelPromise withListener(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        return new AsyncChannelPromise(channel, listener);
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return context.writeAndFlush(message, AsyncChannelPromise.withListener(context.channel(), listener));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return channel.writeAndFlush(message, AsyncChannelPromise.withListener(channel, listener));
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message) {
        return context.writeAndFlush(message, new AsyncChannelPromise(context.channel()));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message) {
        return channel.writeAndFlush(message, new AsyncChannelPromise(channel));
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public ChannelPromise setSuccess() {
        return this.setSuccess(null);
    }

    @Override
    public AsyncChannelPromise setSuccess(Void v) {
        super.setSuccess(v);
        return this;
    }

    @Override
    public boolean trySuccess() {
        return this.trySuccess(null);
    }

    @Override
    public AsyncChannelPromise setFailure(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }

    @Override
    public AsyncChannelPromise sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public AsyncChannelPromise syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public AsyncChannelPromise await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public AsyncChannelPromise awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public AsyncChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        super.addListener(listener);
        return this;
    }

    @Override
    public AsyncChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        super.addListeners(listeners);
        return this;
    }

    @Override
    public AsyncChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AsyncChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelPromise unvoid() {
        return this;
    }
}

