/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent.admin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.repair.consistent.admin.RepairStats;
import org.apache.cassandra.utils.TimeUUID;

public class CleanupSummary {
    private static final String[] COMPOSITE_NAMES = new String[]{"keyspace", "table", "successful", "unsuccessful"};
    private static final OpenType<?>[] COMPOSITE_TYPES;
    private static final CompositeType COMPOSITE_TYPE;
    public final String keyspace;
    public final String table;
    public final Set<TimeUUID> successful;
    public final Set<TimeUUID> unsuccessful;

    public CleanupSummary(String keyspace, String table, Set<TimeUUID> successful, Set<TimeUUID> unsuccessful) {
        this.keyspace = keyspace;
        this.table = table;
        this.successful = successful;
        this.unsuccessful = unsuccessful;
    }

    public CleanupSummary(ColumnFamilyStore cfs, Set<TimeUUID> successful, Set<TimeUUID> unsuccessful) {
        this(cfs.getKeyspaceName(), cfs.name, successful, unsuccessful);
    }

    public static CleanupSummary add(CleanupSummary l, CleanupSummary r) {
        Preconditions.checkArgument(l.keyspace.equals(r.keyspace));
        Preconditions.checkArgument(l.table.equals(r.table));
        HashSet<TimeUUID> unsuccessful = new HashSet<TimeUUID>(l.unsuccessful);
        unsuccessful.addAll(r.unsuccessful);
        HashSet<TimeUUID> successful = new HashSet<TimeUUID>(l.successful);
        successful.addAll(r.successful);
        successful.removeAll(unsuccessful);
        return new CleanupSummary(l.keyspace, l.table, successful, unsuccessful);
    }

    private static String[] uuids2Strings(Set<TimeUUID> uuids) {
        String[] strings = new String[uuids.size()];
        int idx = 0;
        for (TimeUUID uuid : uuids) {
            strings[idx++] = uuid.toString();
        }
        return strings;
    }

    private static Set<TimeUUID> strings2Uuids(String[] strings) {
        HashSet<TimeUUID> uuids = Sets.newHashSetWithExpectedSize(strings.length);
        for (String string : strings) {
            uuids.add(TimeUUID.fromString(string));
        }
        return uuids;
    }

    public CompositeData toComposite() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(COMPOSITE_NAMES[0], this.keyspace);
        values.put(COMPOSITE_NAMES[1], this.table);
        values.put(COMPOSITE_NAMES[2], CleanupSummary.uuids2Strings(this.successful));
        values.put(COMPOSITE_NAMES[3], CleanupSummary.uuids2Strings(this.unsuccessful));
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, values);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static CleanupSummary fromComposite(CompositeData cd2) {
        Preconditions.checkArgument(cd2.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd2.getAll(COMPOSITE_NAMES);
        return new CleanupSummary((String)values[0], (String)values[1], CleanupSummary.strings2Uuids((String[])values[2]), CleanupSummary.strings2Uuids((String[])values[3]));
    }

    static {
        try {
            COMPOSITE_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, ArrayType.getArrayType(SimpleType.STRING), ArrayType.getArrayType(SimpleType.STRING)};
            COMPOSITE_TYPE = new CompositeType(RepairStats.Section.class.getName(), "PendingStats", COMPOSITE_NAMES, COMPOSITE_NAMES, COMPOSITE_TYPES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

