/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.StreamReceiveException;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.StreamingDataInputPlus;
import org.apache.cassandra.streaming.messages.KeepAliveMessage;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDeserializingTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StreamDeserializingTask.class);
    private final StreamingChannel channel;
    private final int messagingVersion;
    @VisibleForTesting
    protected StreamSession session;

    public StreamDeserializingTask(StreamSession session, StreamingChannel channel, int messagingVersion) {
        this.session = session;
        this.channel = channel;
        this.messagingVersion = messagingVersion;
    }

    @Override
    public void run() {
        StreamingDataInputPlus input = this.channel.in();
        try {
            StreamMessage message;
            while (null != (message = StreamMessage.deserialize(input, this.messagingVersion))) {
                if (message instanceof KeepAliveMessage) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{} Received {}", (Object)StreamSession.createLogTag(this.session, this.channel), (Object)message);
                    continue;
                }
                if (this.session == null) {
                    this.session = this.deriveSession(message);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{} Received {}", (Object)StreamSession.createLogTag(this.session, this.channel), (Object)message);
                }
                this.session.messageReceived(message);
            }
        }
        catch (Throwable t2) {
            JVMStabilityInspector.inspectThrowable(t2);
            if (this.session != null) {
                this.session.onError(t2);
            } else if (t2 instanceof StreamReceiveException) {
                ((StreamReceiveException)t2).session.onError(t2.getCause());
            } else {
                logger.error("{} stream operation from {} failed", new Object[]{StreamSession.createLogTag(this.session, this.channel), InetAddressAndPort.toString(this.channel.peer(), true), t2});
            }
        }
        finally {
            this.channel.close();
            input.close();
        }
    }

    @VisibleForTesting
    public StreamSession deriveSession(StreamMessage message) {
        StreamSession streamSession = message.getOrCreateAndAttachInboundSession(this.channel, this.messagingVersion);
        streamSession.attachInbound(this.channel);
        return streamSession;
    }
}

