/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="listcidrgroups", description="List existing cidr groups")
public class ListCIDRGroups
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<cidrGroup>]", description="LIST operation can be invoked with or without cidr group name")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        if (this.args.size() < 1) {
            probe.printSet(out, "CIDR Groups", probe.listAvailableCidrGroups());
            return;
        }
        String cidrGroup = this.args.get(0);
        probe.printSet(out, "CIDRs", probe.listCidrsOfCidrGroup(cidrGroup));
    }
}

