/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="resume", description="Resume bootstrap streaming")
public class BootstrapResume
extends NodeTool.NodeToolCmd {
    @Option(title="force", name={"-f", "--force"}, description="Use --force to resume bootstrap regardless of cassandra.reset_bootstrap_progress environment variable. WARNING: This is potentially dangerous, see CASSANDRA-17679")
    boolean force = false;

    @Override
    protected void execute(NodeProbe probe) {
        try {
            if (!(CassandraRelevantProperties.RESET_BOOTSTRAP_PROGRESS.isPresent() && !CassandraRelevantProperties.RESET_BOOTSTRAP_PROGRESS.getBoolean() || this.force)) {
                throw new RuntimeException("'nodetool bootstrap resume' is disabled.");
            }
            probe.resumeBootstrap(probe.output().out);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

