/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.JMXResource;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="invalidatepermissionscache", description="Invalidate the permissions cache")
public class InvalidatePermissionsCache
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<role>]", description="A role for which permissions to specified resources need to be invalidated")
    private List<String> args = new ArrayList<String>();
    @Option(title="all-keyspaces", name={"--all-keyspaces"}, description="Invalidate permissions for 'ALL KEYSPACES'")
    private boolean allKeyspaces;
    @Option(title="keyspace", name={"--keyspace"}, description="Keyspace to invalidate permissions for")
    private String keyspace;
    @Option(title="all-tables", name={"--all-tables"}, description="Invalidate permissions for 'ALL TABLES'")
    private boolean allTables;
    @Option(title="table", name={"--table"}, description="Table to invalidate permissions for (you must specify --keyspace for using this option)")
    private String table;
    @Option(title="all-roles", name={"--all-roles"}, description="Invalidate permissions for 'ALL ROLES'")
    private boolean allRoles;
    @Option(title="role", name={"--role"}, description="Role to invalidate permissions for")
    private String role;
    @Option(title="all-functions", name={"--all-functions"}, description="Invalidate permissions for 'ALL FUNCTIONS'")
    private boolean allFunctions;
    @Option(title="functions-in-keyspace", name={"--functions-in-keyspace"}, description="Keyspace to invalidate permissions for")
    private String functionsInKeyspace;
    @Option(title="function", name={"--function"}, description="Function to invalidate permissions for (you must specify --functions-in-keyspace for using this option; function format: name[arg1^..^agrN], for example: foo[Int32Type^DoubleType])")
    private String function;
    @Option(title="all-mbeans", name={"--all-mbeans"}, description="Invalidate permissions for 'ALL MBEANS'")
    private boolean allMBeans;
    @Option(title="mbean", name={"--mbean"}, description="MBean to invalidate permissions for")
    private String mBean;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(NodeProbe probe) {
        if (this.args.isEmpty()) {
            Preconditions.checkArgument(!this.allKeyspaces && StringUtils.isEmpty((CharSequence)this.keyspace) && StringUtils.isEmpty((CharSequence)this.table) && !this.allRoles && StringUtils.isEmpty((CharSequence)this.role) && !this.allFunctions && StringUtils.isEmpty((CharSequence)this.functionsInKeyspace) && StringUtils.isEmpty((CharSequence)this.function) && !this.allMBeans && StringUtils.isEmpty((CharSequence)this.mBean), "No resource options allowed without a <role> being specified");
            probe.invalidatePermissionsCache();
            return;
        } else {
            Preconditions.checkArgument(this.args.size() == 1, "A single <role> is only supported / you have a typo in the resource options spelling");
            ArrayList<String> resourceNames = new ArrayList<String>();
            if (this.allKeyspaces) {
                resourceNames.add(DataResource.root().getName());
            }
            if (this.allTables) {
                if (!StringUtils.isNotEmpty((CharSequence)this.keyspace)) throw new IllegalArgumentException("--all-tables option should be passed along with --keyspace option");
                resourceNames.add(DataResource.allTables(this.keyspace).getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.table)) {
                if (!StringUtils.isNotEmpty((CharSequence)this.keyspace)) throw new IllegalArgumentException("--table option should be passed along with --keyspace option");
                resourceNames.add(DataResource.table(this.keyspace, this.table).getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.keyspace) && !this.allTables && StringUtils.isEmpty((CharSequence)this.table)) {
                resourceNames.add(DataResource.keyspace(this.keyspace).getName());
            }
            if (this.allRoles) {
                resourceNames.add(RoleResource.root().getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.role)) {
                resourceNames.add(RoleResource.role(this.role).getName());
            }
            if (this.allFunctions) {
                resourceNames.add(FunctionResource.root().getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.function)) {
                if (!StringUtils.isNotEmpty((CharSequence)this.functionsInKeyspace)) throw new IllegalArgumentException("--function option should be passed along with --functions-in-keyspace option");
                resourceNames.add(this.constructFunctionResource(this.functionsInKeyspace, this.function));
            } else if (StringUtils.isNotEmpty((CharSequence)this.functionsInKeyspace)) {
                resourceNames.add(FunctionResource.keyspace(this.functionsInKeyspace).getName());
            }
            if (this.allMBeans) {
                resourceNames.add(JMXResource.root().getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.mBean)) {
                resourceNames.add(JMXResource.mbean(this.mBean).getName());
            }
            String roleName = this.args.get(0);
            if (resourceNames.isEmpty()) {
                throw new IllegalArgumentException("No resource options specified");
            }
            for (String resourceName : resourceNames) {
                probe.invalidatePermissionsCache(roleName, resourceName);
            }
        }
    }

    private String constructFunctionResource(String functionsInKeyspace, String function) {
        try {
            return FunctionResource.fromName("functions/" + functionsInKeyspace + "/" + function).getName();
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("An error was encountered when looking up function definition: " + e.getMessage());
        }
    }
}

