/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Command(name="upgradesstables", description="Rewrite sstables (for the requested tables) that are not on the current version (thus upgrading them to said current version)")
public class UpgradeSSTable
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
    private List<String> args = new ArrayList<String>();
    @Option(title="include_all", name={"-a", "--include-all-sstables"}, description="Use -a to include all sstables, even those already on the current version")
    private boolean includeAll = false;
    @Option(title="max_timestamp", name={"-t", "--max-timestamp"}, description="Use -t to compact only SSTables that have local creation time _older_ than the given timestamp")
    private long maxSSTableTimestamp = Long.MAX_VALUE;
    @Option(title="jobs", name={"-j", "--jobs"}, description="Number of sstables to upgrade simultanously, set to 0 to use all available compaction threads")
    private int jobs = 2;

    @Override
    public void execute(NodeProbe probe) {
        List<String> keyspaces = this.parseOptionalKeyspace(this.args, probe);
        String[] tableNames = this.parseOptionalTables(this.args);
        block3: for (String keyspace : keyspaces) {
            for (int retries = 0; retries < 5; ++retries) {
                try {
                    if (retries > 0) {
                        Thread.sleep(500L);
                    }
                    probe.upgradeSSTables(probe.output().out, keyspace, !this.includeAll, this.maxSSTableTimestamp, this.jobs, tableNames);
                    continue block3;
                }
                catch (RuntimeException cie) {
                    if (ExceptionUtils.indexOfThrowable((Throwable)cie, CompactionInterruptedException.class) == -1 || retries != 4) continue;
                    throw cie;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred during enabling auto-compaction", e);
                }
            }
        }
    }
}

