/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.utils.BiMultiValMap;

public class SortedBiMultiValMap<K, V>
extends BiMultiValMap<K, V> {
    protected SortedBiMultiValMap(SortedMap<K, V> forwardMap, SortedSetMultimap<V, K> reverseMap) {
        super(forwardMap, reverseMap);
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create() {
        return new SortedBiMultiValMap(new TreeMap(), TreeMultimap.create());
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create(BiMultiValMap<K, V> map) {
        SortedBiMultiValMap<K, V> newMap = SortedBiMultiValMap.create();
        newMap.forwardMap.putAll(map.forwardMap);
        for (Map.Entry<V, Collection<K>> entry : map.inverse().asMap().entrySet()) {
            newMap.reverseMap.putAll((Comparable)entry.getKey(), (Iterable)entry.getValue());
        }
        return newMap;
    }
}

