/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.hunspell.AffixedWord;
import org.apache.lucene.analysis.hunspell.CheckCompoundPattern;
import org.apache.lucene.analysis.hunspell.CompoundRule;
import org.apache.lucene.analysis.hunspell.DictEntry;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.EntrySuggestion;
import org.apache.lucene.analysis.hunspell.RepEntry;
import org.apache.lucene.analysis.hunspell.Root;
import org.apache.lucene.analysis.hunspell.Stemmer;
import org.apache.lucene.analysis.hunspell.Suggester;
import org.apache.lucene.analysis.hunspell.SuggestionTimeoutException;
import org.apache.lucene.analysis.hunspell.TimeoutPolicy;
import org.apache.lucene.analysis.hunspell.WordCase;
import org.apache.lucene.analysis.hunspell.WordContext;
import org.apache.lucene.analysis.hunspell.WordFormGenerator;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;

public class Hunspell {
    static final long SUGGEST_TIME_LIMIT = 250L;
    final Dictionary dictionary;
    final Stemmer stemmer;
    private final TimeoutPolicy policy;
    final Runnable checkCanceled;

    public Hunspell(Dictionary dictionary) {
        this(dictionary, TimeoutPolicy.RETURN_PARTIAL_RESULT, () -> {});
    }

    public Hunspell(Dictionary dictionary, TimeoutPolicy policy, Runnable checkCanceled) {
        this.dictionary = dictionary;
        this.policy = policy;
        this.checkCanceled = checkCanceled;
        this.stemmer = new Stemmer(dictionary);
    }

    public boolean spell(String word) {
        this.checkCanceled.run();
        if (word.isEmpty()) {
            return true;
        }
        if (this.dictionary.needsInputCleaning(word)) {
            word = this.dictionary.cleanInput(word, new StringBuilder()).toString();
        }
        if (word.endsWith(".")) {
            return this.spellWithTrailingDots(word);
        }
        return this.spellClean(word);
    }

    private boolean spellClean(String word) {
        Stemmer.CaseVariationProcessor variationProcessor;
        if (Hunspell.isNumber(word)) {
            return true;
        }
        char[] wordChars = word.toCharArray();
        Boolean simpleResult = this.checkSimpleWord(wordChars, wordChars.length, null);
        if (simpleResult != null) {
            return simpleResult;
        }
        if (this.checkCompounds(wordChars, wordChars.length, null)) {
            return true;
        }
        WordCase wc = this.stemmer.caseOf(wordChars, wordChars.length);
        if (!(wc != WordCase.UPPER && wc != WordCase.TITLE || this.stemmer.varyCase(wordChars, wordChars.length, wc, variationProcessor = (variant, varLength, originalCase) -> !this.checkWord(variant, varLength, originalCase)))) {
            return true;
        }
        if (this.dictionary.breaks.isNotEmpty() && !this.hasTooManyBreakOccurrences(word)) {
            return this.tryBreaks(word);
        }
        return false;
    }

    private boolean spellWithTrailingDots(String word) {
        int length;
        for (length = word.length() - 1; length > 0 && word.charAt(length - 1) == '.'; --length) {
        }
        return this.spellClean(word.substring(0, length)) || this.spellClean(word.substring(0, length + 1));
    }

    boolean checkWord(String word) {
        return this.checkWord(word.toCharArray(), word.length(), null);
    }

    Boolean checkSimpleWord(char[] wordChars, int length, WordCase originalCase) {
        Root<CharsRef> entry = this.findStem(wordChars, 0, length, originalCase, WordContext.SIMPLE_WORD);
        if (entry != null) {
            return !this.dictionary.hasFlag(entry.entryId, this.dictionary.forbiddenword);
        }
        return null;
    }

    private boolean checkWord(char[] wordChars, int length, WordCase originalCase) {
        Boolean simpleResult = this.checkSimpleWord(wordChars, length, originalCase);
        if (simpleResult != null) {
            return simpleResult;
        }
        return this.checkCompounds(wordChars, length, originalCase);
    }

    private boolean checkCompounds(char[] wordChars, int length, WordCase originalCase) {
        if (this.dictionary.compoundRules != null && this.checkCompoundRules(wordChars, 0, length, new ArrayList<IntsRef>())) {
            return true;
        }
        if (this.dictionary.compoundBegin != '\u0000' || this.dictionary.compoundFlag != '\u0000') {
            return this.checkCompounds(new CharsRef(wordChars, 0, length), originalCase, null);
        }
        return false;
    }

    Root<CharsRef> findStem(char[] wordChars, int offset, int length, WordCase originalCase, WordContext context) {
        this.checkCanceled.run();
        WordCase toCheck = context != WordContext.COMPOUND_MIDDLE && context != WordContext.COMPOUND_END ? originalCase : null;
        Root[] result = new Root[1];
        this.stemmer.doStem(wordChars, offset, length, context, (stem, formID, morphDataId, outerPrefix, innerPrefix, outerSuffix, innerSuffix) -> {
            if (!this.acceptCase(toCheck, formID, stem)) {
                return this.dictionary.hasFlag(formID, '\uffe7');
            }
            if (this.acceptsStem(formID)) {
                result[0] = new Root<CharsRef>(stem, formID);
            }
            return false;
        });
        return result[0];
    }

    private boolean acceptCase(WordCase originalCase, int entryId, CharsRef root) {
        boolean keepCase = this.dictionary.hasFlag(entryId, this.dictionary.keepcase);
        if (originalCase != null) {
            if (keepCase && this.dictionary.checkSharpS && originalCase == WordCase.TITLE && this.containsSharpS(root.chars, root.offset, root.length)) {
                return true;
            }
            return !keepCase;
        }
        return !this.dictionary.hasFlag(entryId, '\uffe7');
    }

    private boolean containsSharpS(char[] word, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (word[i + offset] != '\u00df') continue;
            return true;
        }
        return false;
    }

    boolean acceptsStem(int formID) {
        return true;
    }

    private boolean checkCompounds(CharsRef word, WordCase originalCase, CompoundPart prev) {
        if (prev != null && prev.index > this.dictionary.compoundMax - 2) {
            return false;
        }
        if (prev == null && word.offset != 0) {
            throw new IllegalArgumentException();
        }
        int limit = word.length - this.dictionary.compoundMin + 1;
        for (int breakPos = this.dictionary.compoundMin; breakPos < limit; ++breakPos) {
            WordContext context = prev == null ? WordContext.COMPOUND_BEGIN : WordContext.COMPOUND_MIDDLE;
            int breakOffset = word.offset + breakPos;
            if (this.mayBreakIntoCompounds(word.chars, word.offset, word.length, breakOffset)) {
                CompoundPart part;
                Root<CharsRef> stem = this.findStem(word.chars, word.offset, breakPos, originalCase, context);
                if (stem == null && this.dictionary.simplifiedTriple && word.chars[breakOffset - 1] == word.chars[breakOffset]) {
                    stem = this.findStem(word.chars, word.offset, breakPos + 1, originalCase, context);
                }
                if (stem != null && !this.dictionary.hasFlag(stem.entryId, this.dictionary.forbiddenword) && (prev == null || prev.mayCompound(stem, breakPos, originalCase)) && this.checkCompoundsAfter(originalCase, part = new CompoundPart(prev, word, breakPos, stem, null))) {
                    return true;
                }
            }
            if (!this.checkCompoundPatternReplacements(word, breakPos, originalCase, prev)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCompoundPatternReplacements(CharsRef word, int pos, WordCase originalCase, CompoundPart prev) {
        for (CheckCompoundPattern pattern : this.dictionary.checkCompoundPatterns) {
            CompoundPart part;
            WordContext context;
            CharsRef expanded = pattern.expandReplacement(word, pos);
            if (expanded == null) continue;
            WordContext wordContext = context = prev == null ? WordContext.COMPOUND_BEGIN : WordContext.COMPOUND_MIDDLE;
            int breakPos = pos + pattern.endLength();
            Root<CharsRef> stem = this.findStem(expanded.chars, expanded.offset, breakPos, originalCase, context);
            if (stem == null || !this.checkCompoundsAfter(originalCase, part = new CompoundPart(prev, expanded, breakPos, stem, pattern))) continue;
            return true;
        }
        return false;
    }

    private boolean checkCompoundsAfter(WordCase originalCase, CompoundPart prev) {
        CharsRef word = prev.tail;
        int breakPos = prev.length;
        int breakOffset = word.offset + breakPos;
        int remainingLength = word.length - breakPos;
        Root<CharsRef> lastRoot = this.findStem(word.chars, breakOffset, remainingLength, originalCase, WordContext.COMPOUND_END);
        if (!(lastRoot == null || this.dictionary.hasFlag(lastRoot.entryId, this.dictionary.forbiddenword) || this.dictionary.checkCompoundDup && prev.root.equals(lastRoot) || this.hasForceUCaseProblem(lastRoot, originalCase, word.chars) || !prev.mayCompound(lastRoot, remainingLength, originalCase))) {
            return true;
        }
        CharsRef tail = new CharsRef(word.chars, breakOffset, remainingLength);
        return this.checkCompounds(tail, originalCase, prev);
    }

    private boolean hasForceUCaseProblem(Root<?> root, WordCase originalCase, char[] wordChars) {
        if (originalCase == WordCase.TITLE || originalCase == WordCase.UPPER) {
            return false;
        }
        if (originalCase == null && Character.isUpperCase(wordChars[0])) {
            return false;
        }
        return this.dictionary.hasFlag(root.entryId, this.dictionary.forceUCase);
    }

    public List<String> getRoots(String word) {
        return this.stemmer.stem(word).stream().map(CharsRef::toString).distinct().collect(Collectors.toList());
    }

    public List<AffixedWord> analyzeSimpleWord(String word) {
        ArrayList<AffixedWord> result = new ArrayList<AffixedWord>();
        this.stemmer.analyze(word.toCharArray(), word.length(), (stem, formID, morphDataId, outerPrefix, innerPrefix, outerSuffix, innerSuffix) -> {
            ArrayList<AffixedWord.Affix> prefixes = new ArrayList<AffixedWord.Affix>();
            ArrayList<AffixedWord.Affix> suffixes = new ArrayList<AffixedWord.Affix>();
            if (outerPrefix >= 0) {
                prefixes.add(new AffixedWord.Affix(this.dictionary, outerPrefix));
            }
            if (innerPrefix >= 0) {
                prefixes.add(new AffixedWord.Affix(this.dictionary, innerPrefix));
            }
            if (outerSuffix >= 0) {
                suffixes.add(new AffixedWord.Affix(this.dictionary, outerSuffix));
            }
            if (innerSuffix >= 0) {
                suffixes.add(new AffixedWord.Affix(this.dictionary, innerSuffix));
            }
            DictEntry entry = this.dictionary.dictEntry(stem.toString(), formID, morphDataId);
            result.add(new AffixedWord(word, entry, prefixes, suffixes));
            return true;
        });
        return result;
    }

    public List<AffixedWord> getAllWordForms(String root) {
        return new WordFormGenerator(this.dictionary).getAllWordForms(root, this.checkCanceled);
    }

    public EntrySuggestion compress(List<String> words) {
        return new WordFormGenerator(this.dictionary).compress(words, Set.of(), this.checkCanceled);
    }

    private boolean mayBreakIntoCompounds(char[] chars, int offset, int length, int breakPos) {
        if (this.dictionary.checkCompoundCase) {
            char a = chars[breakPos - 1];
            char b = chars[breakPos];
            if ((Character.isUpperCase(a) || Character.isUpperCase(b)) && a != '-' && b != '-') {
                return false;
            }
        }
        return !this.dictionary.checkCompoundTriple || chars[breakPos - 1] != chars[breakPos] || (breakPos <= offset + 1 || chars[breakPos - 2] != chars[breakPos - 1]) && (breakPos >= length - 1 || chars[breakPos] != chars[breakPos + 1]);
    }

    private boolean checkCompoundRules(char[] wordChars, int offset, int length, List<IntsRef> words) {
        if (words.size() >= 100) {
            return false;
        }
        this.checkCanceled.run();
        int limit = length - this.dictionary.compoundMin + 1;
        for (int breakPos = this.dictionary.compoundMin; breakPos < limit; ++breakPos) {
            IntsRef forms = this.dictionary.lookupWord(wordChars, offset, breakPos);
            if (forms == null) continue;
            words.add(forms);
            if (this.mayHaveCompoundRule(words)) {
                if (this.checkLastCompoundPart(wordChars, offset + breakPos, length - breakPos, words)) {
                    return true;
                }
                if (this.checkCompoundRules(wordChars, offset + breakPos, length - breakPos, words)) {
                    return true;
                }
            }
            words.remove(words.size() - 1);
        }
        return false;
    }

    private boolean mayHaveCompoundRule(List<IntsRef> words) {
        for (CompoundRule rule : this.dictionary.compoundRules) {
            if (!rule.mayMatch(words)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLastCompoundPart(char[] wordChars, int start, int length, List<IntsRef> words) {
        IntsRef ref = new IntsRef(new int[1], 0, 1);
        words.add(ref);
        Stemmer.RootProcessor stopOnMatching = (stem, formID, morphDataId, outerPrefix, innerPrefix, outerSuffix, innerSuffix) -> {
            ref.ints[0] = formID;
            for (CompoundRule r : this.dictionary.compoundRules) {
                if (!r.fullyMatches(words)) continue;
                return false;
            }
            return true;
        };
        boolean found = !this.stemmer.doStem(wordChars, start, length, WordContext.COMPOUND_RULE_END, stopOnMatching);
        words.remove(words.size() - 1);
        return found;
    }

    private static boolean isNumber(String s2) {
        int i = 0;
        while (i < s2.length()) {
            char c = s2.charAt(i);
            if (Hunspell.isDigit(c)) {
                ++i;
                continue;
            }
            if (c == '.' || c == ',' || c == '-') {
                if (i == 0 || i >= s2.length() - 1 || !Hunspell.isDigit(s2.charAt(i + 1))) {
                    return false;
                }
                i += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean tryBreaks(String word) {
        for (String br : this.dictionary.breaks.starting) {
            if (word.length() <= br.length() || !word.startsWith(br) || !this.spell(word.substring(br.length()))) continue;
            return true;
        }
        for (String br : this.dictionary.breaks.ending) {
            if (word.length() <= br.length() || !word.endsWith(br) || !this.spell(word.substring(0, word.length() - br.length()))) continue;
            return true;
        }
        for (String br : this.dictionary.breaks.middle) {
            int pos = word.indexOf(br);
            if (this.canBeBrokenAt(word, br, pos)) {
                return true;
            }
            if (pos <= 0 || !this.canBeBrokenAt(word, br, word.indexOf(br, pos + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean hasTooManyBreakOccurrences(String word) {
        int occurrences = 0;
        for (String br : this.dictionary.breaks.middle) {
            int pos = 0;
            while ((pos = word.indexOf(br, pos)) >= 0) {
                if (++occurrences >= 10) {
                    return true;
                }
                pos += br.length();
            }
        }
        return false;
    }

    private boolean canBeBrokenAt(String word, String breakStr, int breakPos) {
        return breakPos > 0 && breakPos < word.length() - breakStr.length() && this.spell(word.substring(0, breakPos)) && this.spell(word.substring(breakPos + breakStr.length()));
    }

    public List<String> suggest(String word) throws SuggestionTimeoutException {
        return this.suggest(word, 250L);
    }

    public List<String> suggest(String word, long timeLimitMs) throws SuggestionTimeoutException {
        Suggester suggester = new Suggester(this.dictionary);
        if (this.policy == TimeoutPolicy.NO_TIMEOUT) {
            return suggester.suggestNoTimeout(word, this.checkCanceled);
        }
        try {
            return suggester.suggestWithTimeout(word, timeLimitMs, this.checkCanceled);
        }
        catch (SuggestionTimeoutException e) {
            if (this.policy == TimeoutPolicy.RETURN_PARTIAL_RESULT) {
                return e.getPartialResult();
            }
            throw e;
        }
    }

    private class CompoundPart {
        final CompoundPart prev;
        final int index;
        final int length;
        final CharsRef tail;
        final Root<CharsRef> root;
        final CheckCompoundPattern enablingPattern;

        CompoundPart(CompoundPart prev, CharsRef tail, int length, Root<CharsRef> root, CheckCompoundPattern enabler) {
            this.prev = prev;
            this.tail = tail;
            this.length = length;
            this.root = root;
            this.index = prev == null ? 1 : prev.index + 1;
            this.enablingPattern = enabler;
        }

        public String toString() {
            return (String)(this.prev == null ? "" : this.prev + "+") + this.tail.subSequence(0, this.length);
        }

        boolean mayCompound(Root<CharsRef> nextRoot, int nextPartLength, WordCase originalCase) {
            boolean patternsOk;
            boolean bl = patternsOk = this.enablingPattern != null ? this.enablingPattern.prohibitsCompounding(this.tail, this.length, this.root, nextRoot) : Hunspell.this.dictionary.checkCompoundPatterns.stream().noneMatch(p -> p.prohibitsCompounding(this.tail, this.length, this.root, nextRoot));
            if (!patternsOk) {
                return false;
            }
            if (Hunspell.this.dictionary.checkCompoundRep && this.isMisspelledSimpleWord(this.length + nextPartLength, originalCase)) {
                return false;
            }
            char[] spaceSeparated = new char[this.length + nextPartLength + 1];
            System.arraycopy(this.tail.chars, this.tail.offset, spaceSeparated, 0, this.length);
            System.arraycopy(this.tail.chars, this.tail.offset + this.length, spaceSeparated, this.length + 1, nextPartLength);
            spaceSeparated[this.length] = 32;
            return !Boolean.TRUE.equals(Hunspell.this.checkSimpleWord(spaceSeparated, spaceSeparated.length, null));
        }

        private boolean isMisspelledSimpleWord(int length, WordCase originalCase) {
            String word = new String(this.tail.chars, this.tail.offset, length);
            for (RepEntry entry : Hunspell.this.dictionary.repTable) {
                if (!entry.isMiddle()) continue;
                for (String sug : entry.substitute(word)) {
                    if (Hunspell.this.findStem(sug.toCharArray(), 0, sug.length(), originalCase, WordContext.SIMPLE_WORD) == null) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

