/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.internal.tests.ConcurrentMergeSchedulerAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.ThreadInterruptedException;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    public static final int AUTO_DETECT_MERGES_AND_THREADS = -1;
    public static final String DEFAULT_CPU_CORE_COUNT_PROPERTY = "lucene.cms.override_core_count";
    protected final List<MergeThread> mergeThreads = new ArrayList<MergeThread>();
    private int maxThreadCount = -1;
    private int maxMergeCount = -1;
    protected int mergeThreadCount;
    private static final double MIN_MERGE_MB_PER_SEC = 5.0;
    private static final double MAX_MERGE_MB_PER_SEC = 10240.0;
    private static final double START_MB_PER_SEC = 20.0;
    private static final double MIN_BIG_MERGE_MB = 50.0;
    protected double targetMBPerSec = 20.0;
    private boolean doAutoIOThrottle = true;
    private double forceMergeMBPerSec = Double.POSITIVE_INFINITY;
    private boolean suppressExceptions;

    public synchronized void setMaxMergesAndThreads(int maxMergeCount, int maxThreadCount) {
        if (maxMergeCount == -1 && maxThreadCount == -1) {
            this.maxMergeCount = -1;
            this.maxThreadCount = -1;
        } else {
            if (maxMergeCount == -1) {
                throw new IllegalArgumentException("both maxMergeCount and maxThreadCount must be AUTO_DETECT_MERGES_AND_THREADS");
            }
            if (maxThreadCount == -1) {
                throw new IllegalArgumentException("both maxMergeCount and maxThreadCount must be AUTO_DETECT_MERGES_AND_THREADS");
            }
            if (maxThreadCount < 1) {
                throw new IllegalArgumentException("maxThreadCount should be at least 1");
            }
            if (maxMergeCount < 1) {
                throw new IllegalArgumentException("maxMergeCount should be at least 1");
            }
            if (maxThreadCount > maxMergeCount) {
                throw new IllegalArgumentException("maxThreadCount should be <= maxMergeCount (= " + maxMergeCount + ")");
            }
            this.maxThreadCount = maxThreadCount;
            this.maxMergeCount = maxMergeCount;
        }
    }

    public synchronized void setDefaultMaxMergesAndThreads(boolean spins) {
        if (spins) {
            this.maxThreadCount = 1;
            this.maxMergeCount = 6;
        } else {
            int coreCount = Runtime.getRuntime().availableProcessors();
            try {
                String value = System.getProperty(DEFAULT_CPU_CORE_COUNT_PROPERTY);
                if (value != null) {
                    coreCount = Integer.parseInt(value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.maxThreadCount = Math.max(1, Math.min(4, coreCount / 2));
            this.maxMergeCount = this.maxThreadCount + 5;
        }
    }

    public synchronized void setForceMergeMBPerSec(double v) {
        this.forceMergeMBPerSec = v;
        this.updateMergeThreads();
    }

    public synchronized double getForceMergeMBPerSec() {
        return this.forceMergeMBPerSec;
    }

    public synchronized void enableAutoIOThrottle() {
        this.doAutoIOThrottle = true;
        this.targetMBPerSec = 20.0;
        this.updateMergeThreads();
    }

    public synchronized void disableAutoIOThrottle() {
        this.doAutoIOThrottle = false;
        this.updateMergeThreads();
    }

    public synchronized boolean getAutoIOThrottle() {
        return this.doAutoIOThrottle;
    }

    public synchronized double getIORateLimitMBPerSec() {
        if (this.doAutoIOThrottle) {
            return this.targetMBPerSec;
        }
        return Double.POSITIVE_INFINITY;
    }

    public synchronized int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    synchronized void removeMergeThread() {
        Thread currentThread = Thread.currentThread();
        for (int i = 0; i < this.mergeThreads.size(); ++i) {
            if (this.mergeThreads.get(i) != currentThread) continue;
            this.mergeThreads.remove(i);
            return;
        }
        assert (false) : "merge thread " + currentThread + " was not found";
    }

    @Override
    public Directory wrapForMerge(MergePolicy.OneMerge merge, Directory in) {
        final Thread mergeThread = Thread.currentThread();
        if (!MergeThread.class.isInstance(mergeThread)) {
            throw new AssertionError((Object)("wrapForMerge should be called from MergeThread. Current thread: " + mergeThread));
        }
        final MergeRateLimiter rateLimiter = ((MergeThread)mergeThread).rateLimiter;
        return new FilterDirectory(in){

            @Override
            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                this.ensureOpen();
                assert (context.context == IOContext.Context.MERGE) : "got context=" + context.context;
                assert (mergeThread == Thread.currentThread()) : "Not the same merge thread, current=" + Thread.currentThread() + ", expected=" + mergeThread;
                return new RateLimitedIndexOutput(rateLimiter, this.in.createOutput(name, context));
            }
        };
    }

    protected synchronized void updateMergeThreads() {
        StringBuilder message;
        ArrayList<MergeThread> activeMerges = new ArrayList<MergeThread>();
        int threadIdx = 0;
        while (threadIdx < this.mergeThreads.size()) {
            MergeThread mergeThread = this.mergeThreads.get(threadIdx);
            if (!mergeThread.isAlive()) {
                this.mergeThreads.remove(threadIdx);
                continue;
            }
            activeMerges.add(mergeThread);
            ++threadIdx;
        }
        CollectionUtil.timSort(activeMerges);
        int activeMergeCount = activeMerges.size();
        int bigMergeCount = 0;
        for (threadIdx = activeMergeCount - 1; threadIdx >= 0; --threadIdx) {
            MergeThread mergeThread = (MergeThread)activeMerges.get(threadIdx);
            if (!((double)mergeThread.merge.estimatedMergeBytes > 5.24288E7)) continue;
            bigMergeCount = 1 + threadIdx;
            break;
        }
        long now = System.nanoTime();
        if (this.verbose()) {
            message = new StringBuilder();
            message.append(String.format(Locale.ROOT, "updateMergeThreads ioThrottle=%s targetMBPerSec=%.1f MB/sec", this.doAutoIOThrottle, this.targetMBPerSec));
        } else {
            message = null;
        }
        for (threadIdx = 0; threadIdx < activeMergeCount; ++threadIdx) {
            boolean doPause;
            MergeThread mergeThread = (MergeThread)activeMerges.get(threadIdx);
            MergePolicy.OneMerge merge = mergeThread.merge;
            boolean bl = doPause = threadIdx < bigMergeCount - this.maxThreadCount;
            double newMBPerSec = doPause ? 0.0 : (merge.maxNumSegments != -1 ? this.forceMergeMBPerSec : (!this.doAutoIOThrottle ? Double.POSITIVE_INFINITY : ((double)merge.estimatedMergeBytes < 5.24288E7 ? Double.POSITIVE_INFINITY : this.targetMBPerSec)));
            MergeRateLimiter rateLimiter = mergeThread.rateLimiter;
            double curMBPerSec = rateLimiter.getMBPerSec();
            if (this.verbose()) {
                long mergeStartNS = merge.mergeStartNS;
                if (mergeStartNS == -1L) {
                    mergeStartNS = now;
                }
                message.append('\n');
                message.append(String.format(Locale.ROOT, "merge thread %s estSize=%.1f MB (written=%.1f MB) runTime=%.1fs (stopped=%.1fs, paused=%.1fs) rate=%s\n", mergeThread.getName(), ConcurrentMergeScheduler.bytesToMB(merge.estimatedMergeBytes), ConcurrentMergeScheduler.bytesToMB(rateLimiter.getTotalBytesWritten()), ConcurrentMergeScheduler.nsToSec(now - mergeStartNS), ConcurrentMergeScheduler.nsToSec(rateLimiter.getTotalStoppedNS()), ConcurrentMergeScheduler.nsToSec(rateLimiter.getTotalPausedNS()), ConcurrentMergeScheduler.rateToString(rateLimiter.getMBPerSec())));
                if (newMBPerSec != curMBPerSec) {
                    if (newMBPerSec == 0.0) {
                        message.append("  now stop");
                    } else if (curMBPerSec == 0.0) {
                        if (newMBPerSec == Double.POSITIVE_INFINITY) {
                            message.append("  now resume");
                        } else {
                            message.append(String.format(Locale.ROOT, "  now resume to %.1f MB/sec", newMBPerSec));
                        }
                    } else {
                        message.append(String.format(Locale.ROOT, "  now change from %.1f MB/sec to %.1f MB/sec", curMBPerSec, newMBPerSec));
                    }
                } else if (curMBPerSec == 0.0) {
                    message.append("  leave stopped");
                } else {
                    message.append(String.format(Locale.ROOT, "  leave running at %.1f MB/sec", curMBPerSec));
                }
            }
            rateLimiter.setMBPerSec(newMBPerSec);
        }
        if (this.verbose()) {
            this.message(message.toString());
        }
    }

    private synchronized void initDynamicDefaults(Directory directory) throws IOException {
        if (this.maxThreadCount == -1) {
            this.setDefaultMaxMergesAndThreads(false);
            if (this.verbose()) {
                this.message("initDynamicDefaults maxThreadCount=" + this.maxThreadCount + " maxMergeCount=" + this.maxMergeCount);
            }
        }
    }

    private static String rateToString(double mbPerSec) {
        if (mbPerSec == 0.0) {
            return "stopped";
        }
        if (mbPerSec == Double.POSITIVE_INFINITY) {
            return "unlimited";
        }
        return String.format(Locale.ROOT, "%.1f MB/sec", mbPerSec);
    }

    @Override
    public void close() {
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        block12: {
            boolean interrupted = false;
            block8: while (true) {
                while (true) {
                    Thread toSync = null;
                    ConcurrentMergeScheduler concurrentMergeScheduler = this;
                    synchronized (concurrentMergeScheduler) {
                        for (MergeThread t2 : this.mergeThreads) {
                            if (!t2.isAlive() || t2 == Thread.currentThread()) continue;
                            toSync = t2;
                            break;
                        }
                    }
                    if (toSync == null) break block12;
                    try {
                        toSync.join();
                        continue block8;
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public synchronized int mergeThreadCount() {
        Thread currentThread = Thread.currentThread();
        int count = 0;
        for (MergeThread mergeThread : this.mergeThreads) {
            if (currentThread == mergeThread || !mergeThread.isAlive() || mergeThread.merge.isAborted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    void initialize(InfoStream infoStream, Directory directory) throws IOException {
        super.initialize(infoStream, directory);
        this.initDynamicDefaults(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
        if (trigger == MergeTrigger.CLOSING) {
            this.targetMBPerSec = 10240.0;
            this.updateMergeThreads();
        }
        if (this.verbose()) {
            this.message("now merge");
            this.message("  index(source): " + mergeSource.toString());
        }
        while (this.maybeStall(mergeSource)) {
            MergePolicy.OneMerge merge = mergeSource.getNextMerge();
            if (merge == null) {
                if (this.verbose()) {
                    this.message("  no more merges pending; now return");
                }
                return;
            }
            boolean success = false;
            try {
                MergeThread newMergeThread = this.getMergeThread(mergeSource, merge);
                this.mergeThreads.add(newMergeThread);
                this.updateIOThrottle(newMergeThread.merge, newMergeThread.rateLimiter);
                if (this.verbose()) {
                    this.message("    launch new thread [" + newMergeThread.getName() + "]");
                }
                newMergeThread.start();
                this.updateMergeThreads();
                success = true;
            }
            finally {
                if (success) continue;
                mergeSource.onMergeFinished(merge);
            }
        }
    }

    protected synchronized boolean maybeStall(MergeScheduler.MergeSource mergeSource) {
        long startStallTime = 0L;
        while (mergeSource.hasPendingMerges() && this.mergeThreadCount() >= this.maxMergeCount) {
            if (this.mergeThreads.contains(Thread.currentThread())) {
                return false;
            }
            if (startStallTime == 0L) {
                startStallTime = System.currentTimeMillis();
                if (this.verbose()) {
                    this.message("    too many merges; stalling...");
                }
            }
            this.doStall();
        }
        if (this.verbose() && startStallTime != 0L) {
            this.message("  stalled for " + (System.currentTimeMillis() - startStallTime) + " ms");
        }
        return true;
    }

    protected synchronized void doStall() {
        try {
            this.wait(250L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    protected void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        mergeSource.merge(merge);
    }

    protected synchronized MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        MergeThread thread = new MergeThread(mergeSource, merge);
        thread.setDaemon(true);
        thread.setName("Lucene Merge Thread #" + this.mergeThreadCount++);
        return thread;
    }

    synchronized void runOnMergeFinished(MergeScheduler.MergeSource mergeSource) {
        assert (this.mergeThreads.contains(Thread.currentThread())) : "caller is not a merge thread";
        try {
            this.merge(mergeSource, MergeTrigger.MERGE_FINISHED);
        }
        catch (AlreadyClosedException alreadyClosedException) {
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        finally {
            this.removeMergeThread();
            this.updateMergeThreads();
            this.notifyAll();
        }
    }

    protected void handleMergeException(Throwable exc) {
        throw new MergePolicy.MergeException(exc);
    }

    void setSuppressExceptions() {
        if (this.verbose()) {
            this.message("will suppress merge exceptions");
        }
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        if (this.verbose()) {
            this.message("will not suppress merge exceptions");
        }
        this.suppressExceptions = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + ": ");
        sb.append("maxThreadCount=").append(this.maxThreadCount).append(", ");
        sb.append("maxMergeCount=").append(this.maxMergeCount).append(", ");
        sb.append("ioThrottle=").append(this.doAutoIOThrottle);
        return sb.toString();
    }

    private boolean isBacklog(long now, MergePolicy.OneMerge merge) {
        double mergeMB = ConcurrentMergeScheduler.bytesToMB(merge.estimatedMergeBytes);
        for (MergeThread mergeThread : this.mergeThreads) {
            double otherMergeMB;
            double ratio;
            long mergeStartNS = mergeThread.merge.mergeStartNS;
            if (!mergeThread.isAlive() || mergeThread.merge == merge || mergeStartNS == -1L || !((double)mergeThread.merge.estimatedMergeBytes >= 5.24288E7) || !(ConcurrentMergeScheduler.nsToSec(now - mergeStartNS) > 3.0) || !((ratio = (otherMergeMB = ConcurrentMergeScheduler.bytesToMB(mergeThread.merge.estimatedMergeBytes)) / mergeMB) > 0.3) || !(ratio < 3.0)) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateIOThrottle(MergePolicy.OneMerge newMerge, MergeRateLimiter rateLimiter) throws IOException {
        if (!this.doAutoIOThrottle) {
            return;
        }
        double mergeMB = ConcurrentMergeScheduler.bytesToMB(newMerge.estimatedMergeBytes);
        if (mergeMB < 50.0) {
            return;
        }
        long now = System.nanoTime();
        boolean newBacklog = this.isBacklog(now, newMerge);
        boolean curBacklog = false;
        if (!newBacklog) {
            if (this.mergeThreads.size() > this.maxThreadCount) {
                curBacklog = true;
            } else {
                for (MergeThread mergeThread : this.mergeThreads) {
                    if (!this.isBacklog(now, mergeThread.merge)) continue;
                    curBacklog = true;
                    break;
                }
            }
        }
        double curMBPerSec = this.targetMBPerSec;
        if (newBacklog) {
            this.targetMBPerSec *= 1.2;
            if (this.targetMBPerSec > 10240.0) {
                this.targetMBPerSec = 10240.0;
            }
            if (this.verbose()) {
                if (curMBPerSec == this.targetMBPerSec) {
                    this.message(String.format(Locale.ROOT, "io throttle: new merge backlog; leave IO rate at ceiling %.1f MB/sec", this.targetMBPerSec));
                } else {
                    this.message(String.format(Locale.ROOT, "io throttle: new merge backlog; increase IO rate to %.1f MB/sec", this.targetMBPerSec));
                }
            }
        } else if (curBacklog) {
            if (this.verbose()) {
                this.message(String.format(Locale.ROOT, "io throttle: current merge backlog; leave IO rate at %.1f MB/sec", this.targetMBPerSec));
            }
        } else {
            this.targetMBPerSec /= 1.1;
            if (this.targetMBPerSec < 5.0) {
                this.targetMBPerSec = 5.0;
            }
            if (this.verbose()) {
                if (curMBPerSec == this.targetMBPerSec) {
                    this.message(String.format(Locale.ROOT, "io throttle: no merge backlog; leave IO rate at floor %.1f MB/sec", this.targetMBPerSec));
                } else {
                    this.message(String.format(Locale.ROOT, "io throttle: no merge backlog; decrease IO rate to %.1f MB/sec", this.targetMBPerSec));
                }
            }
        }
        double rate = newMerge.maxNumSegments != -1 ? this.forceMergeMBPerSec : this.targetMBPerSec;
        rateLimiter.setMBPerSec(rate);
        this.targetMBPerSecChanged();
    }

    protected void targetMBPerSecChanged() {
    }

    private static double nsToSec(long ns) {
        return (double)ns / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    private static double bytesToMB(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    private static String getSegmentName(MergePolicy.OneMerge merge) {
        return merge.info != null ? merge.info.info.name : "_na_";
    }

    static {
        TestSecrets.setConcurrentMergeSchedulerAccess(new ConcurrentMergeSchedulerAccess(){

            @Override
            public void setSuppressExceptions(ConcurrentMergeScheduler cms) {
                cms.setSuppressExceptions();
            }
        });
    }

    protected class MergeThread
    extends Thread
    implements Comparable<MergeThread> {
        final MergeScheduler.MergeSource mergeSource;
        final MergePolicy.OneMerge merge;
        final MergeRateLimiter rateLimiter;

        public MergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) {
            this.mergeSource = mergeSource;
            this.merge = merge;
            this.rateLimiter = new MergeRateLimiter(merge.getMergeProgress());
        }

        @Override
        public int compareTo(MergeThread other) {
            return Long.compare(other.merge.estimatedMergeBytes, this.merge.estimatedMergeBytes);
        }

        @Override
        public void run() {
            block5: {
                try {
                    if (ConcurrentMergeScheduler.this.verbose()) {
                        ConcurrentMergeScheduler.this.message(String.format(Locale.ROOT, "merge thread %s start", this.getName()));
                    }
                    ConcurrentMergeScheduler.this.doMerge(this.mergeSource, this.merge);
                    if (ConcurrentMergeScheduler.this.verbose()) {
                        ConcurrentMergeScheduler.this.message(String.format(Locale.ROOT, "merge thread %s merge segment [%s] done estSize=%.1f MB (written=%.1f MB) runTime=%.1fs (stopped=%.1fs, paused=%.1fs) rate=%s", this.getName(), ConcurrentMergeScheduler.getSegmentName(this.merge), ConcurrentMergeScheduler.bytesToMB(this.merge.estimatedMergeBytes), ConcurrentMergeScheduler.bytesToMB(this.rateLimiter.getTotalBytesWritten()), ConcurrentMergeScheduler.nsToSec(System.nanoTime() - this.merge.mergeStartNS), ConcurrentMergeScheduler.nsToSec(this.rateLimiter.getTotalStoppedNS()), ConcurrentMergeScheduler.nsToSec(this.rateLimiter.getTotalPausedNS()), ConcurrentMergeScheduler.rateToString(this.rateLimiter.getMBPerSec())));
                    }
                    ConcurrentMergeScheduler.this.runOnMergeFinished(this.mergeSource);
                    if (ConcurrentMergeScheduler.this.verbose()) {
                        ConcurrentMergeScheduler.this.message(String.format(Locale.ROOT, "merge thread %s end", this.getName()));
                    }
                }
                catch (Throwable exc) {
                    if (exc instanceof MergePolicy.MergeAbortedException || ConcurrentMergeScheduler.this.suppressExceptions) break block5;
                    ConcurrentMergeScheduler.this.handleMergeException(exc);
                }
            }
        }
    }
}

