/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.string;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Optional;
import org.github.jamm.CannotAccessFieldException;
import org.github.jamm.MemoryMeter;
import org.github.jamm.MemoryMeterStrategy;
import org.github.jamm.VM;
import org.github.jamm.strategies.MemoryMeterStrategies;
import org.github.jamm.string.PlainReflectionStringMeter;
import org.github.jamm.string.PreJava9StringMeter;
import org.github.jamm.string.UnsafeStringMeter;
import org.github.jamm.utils.MethodHandleUtils;
import sun.misc.Unsafe;

public abstract class StringMeter {
    public static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("org.github.jamm.string.Optimize", "true"));
    public static final long STRING_SHALLOW_SIZE = MemoryMeterStrategies.getInstance().getStrategy(MemoryMeter.BEST).measure("");

    public long measureDeep(MemoryMeterStrategy strategy, String s2) {
        return STRING_SHALLOW_SIZE + this.measureStringValue(strategy, s2);
    }

    protected abstract long measureStringValue(MemoryMeterStrategy var1, String var2);

    public static StringMeter newInstance() {
        try {
            Field field = String.class.getDeclaredField("value");
            Optional<MethodHandle> mayBeTrySetAccessible = MethodHandleUtils.mayBeMethodHandle(Field.class, "trySetAccessible");
            if (mayBeTrySetAccessible.isPresent()) {
                Unsafe unsafe = VM.getUnsafe();
                if (unsafe == null) {
                    if (mayBeTrySetAccessible.get().invoke(field)) {
                        return new PlainReflectionStringMeter(MethodHandleUtils.methodHandle(field));
                    }
                    throw new CannotAccessFieldException("The value of the 'value' field from java.lang.String cannot be retrieved as the field cannot be made accessible and Unsafe is unavailable");
                }
                long valueFieldOffset = unsafe.objectFieldOffset(field);
                return new UnsafeStringMeter(unsafe, valueFieldOffset);
            }
            field.setAccessible(true);
            return new PreJava9StringMeter(MethodHandleUtils.methodHandle(field));
        }
        catch (Throwable e) {
            throw new CannotAccessFieldException("The value of the 'value' field from java.lang.String cannot be retrieved", e);
        }
    }
}

