/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.SysLogger;

public class MxPingCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "mxping";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new MxPingInfo(host);
    }

    @Parameters(commandDescription="[MXPING] Verify JMX connection to target JVM")
    public static class MxPingInfo
    implements Runnable {
        @ParametersDelegate
        private final CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;

        public MxPingInfo(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            RuntimeMXBean rtbean;
            ObjectName on;
            SysLogger.DEBUG.setTarget(System.out);
            SysLogger.INFO.setTarget(System.out);
            this.connInfo.setDiagMode(true);
            RuntimeMXBean rtinfo = ManagementFactory.getRuntimeMXBean();
            System.out.println("SJK is running on: " + rtinfo.getVmName() + " " + rtinfo.getVmVersion() + " (" + rtinfo.getVmVendor() + ")");
            System.out.println("Java home: " + System.getProperty("java.home"));
            MBeanServerConnection mserver = this.connInfo.getMServer();
            try {
                on = new ObjectName("java.lang:type=Runtime");
            }
            catch (Exception e) {
                this.host.fail("", e);
                return;
            }
            try {
                rtbean = JMX.newMBeanProxy(mserver, on, RuntimeMXBean.class);
            }
            catch (Exception e) {
                this.host.fail("Faield to access remote Runtime MBean", e);
                return;
            }
            System.out.println("Remote VM: " + rtbean.getVmName() + " " + rtbean.getVmVersion() + " (" + rtbean.getVmVendor() + ")");
        }
    }
}

