/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Ps
extends SigarCommandBase {
    public Ps(Shell shell) {
        super(shell);
    }

    public Ps() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getSyntaxArgs() {
        return "[pid|query]";
    }

    public String getUsageShort() {
        return "Show process status";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        long[] pids = args.length == 0 ? this.proxy.getProcList() : this.shell.findPids(args);
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            try {
                this.output(pid);
                continue;
            }
            catch (SigarException e) {
                this.err.println("Exception getting process info for " + pid + ": " + e.getMessage());
            }
        }
    }

    public static String join(List info) {
        StringBuffer buf = new StringBuffer();
        Iterator i = info.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            buf.append((String)i.next());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append("\t");
        }
        return buf.toString();
    }

    public static List getInfo(SigarProxy sigar, long pid) throws SigarException {
        ProcState state = sigar.getProcState(pid);
        ProcTime time = null;
        String unknown = "???";
        ArrayList<String> info = new ArrayList<String>();
        info.add(String.valueOf(pid));
        try {
            ProcCredName cred = sigar.getProcCredName(pid);
            info.add(cred.getUser());
        }
        catch (SigarException e) {
            info.add(unknown);
        }
        try {
            time = sigar.getProcTime(pid);
            info.add(Ps.getStartTime(time.getStartTime()));
        }
        catch (SigarException e) {
            info.add(unknown);
        }
        try {
            ProcMem mem = sigar.getProcMem(pid);
            info.add(Sigar.formatSize(mem.getSize()));
            info.add(Sigar.formatSize(mem.getRss()));
            info.add(Sigar.formatSize(mem.getShare()));
        }
        catch (SigarException e) {
            info.add(unknown);
        }
        info.add(String.valueOf(state.getState()));
        if (time != null) {
            info.add(Ps.getCpuTime(time));
        } else {
            info.add(unknown);
        }
        String name = ProcUtil.getDescription(sigar, pid);
        info.add(name);
        return info;
    }

    public void output(long pid) throws SigarException {
        this.println(Ps.join(Ps.getInfo(this.proxy, pid)));
    }

    public static String getCpuTime(long total) {
        long t2 = total / 1000L;
        return t2 / 60L + ":" + t2 % 60L;
    }

    public static String getCpuTime(ProcTime time) {
        return Ps.getCpuTime(time.getTotal());
    }

    private static String getStartTime(long time) {
        if (time == 0L) {
            return "00:00";
        }
        long timeNow = System.currentTimeMillis();
        String fmt = "MMMd";
        if (timeNow - time < 86400000L) {
            fmt = "HH:mm";
        }
        return new SimpleDateFormat(fmt).format(new Date(time));
    }

    public static void main(String[] args) throws Exception {
        new Ps().processCommand(args);
    }
}

