/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.spark.bulkwriter.BroadcastableJobInfo;
import org.apache.cassandra.spark.bulkwriter.BroadcastableSchemaInfo;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterConfig;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CassandraJobInfo;
import org.apache.cassandra.spark.bulkwriter.CassandraSchemaInfo;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CqlTableInfoProvider;
import org.apache.cassandra.spark.bulkwriter.IBroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.SchemaInfo;
import org.apache.cassandra.spark.bulkwriter.TableInfoProvider;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TokenPartitioner;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.stats.JobStatsPublisher;
import org.apache.cassandra.spark.common.stats.LogStatsPublisher;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.QualifiedTableName;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.CqlUtils;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkWriterContext
implements BulkWriterContext,
KryoSerializable {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BulkSparkConf conf;
    private final int sparkDefaultParallelism;
    private final JobInfo jobInfo;
    private final ClusterInfo clusterInfo;
    private final SchemaInfo schemaInfo;
    private final String lowestCassandraVersion;
    private volatile transient CassandraBridge bridge;
    private volatile transient JobStatsPublisher jobStatsPublisher;
    private volatile transient TransportContext transportContext;
    public static final String KRYO_REGISTRATION_WARNING = "Spark Bulk Writer Kryo Registrator (SbwKryoRegistrator) was not registered with Spark - please see the README.md file for more details on how to register the Spark Bulk Writer.";

    protected AbstractBulkWriterContext(@NotNull BulkSparkConf conf, @NotNull StructType structType, @NotNull int sparkDefaultParallelism) {
        this.conf = conf;
        this.sparkDefaultParallelism = sparkDefaultParallelism;
        this.clusterInfo = this.buildClusterInfo();
        this.clusterInfo.startupValidate();
        this.lowestCassandraVersion = this.findLowestCassandraVersion();
        this.bridge = this.buildCassandraBridge();
        this.jobInfo = this.buildJobInfo();
        this.schemaInfo = this.buildSchemaInfo(structType);
        this.jobStatsPublisher = this.buildJobStatsPublisher();
        this.transportContext = this.buildTransportContext(true);
    }

    protected AbstractBulkWriterContext(@NotNull BulkWriterConfig config) {
        this.conf = config.getConf();
        this.sparkDefaultParallelism = config.getSparkDefaultParallelism();
        this.clusterInfo = this.reconstructClusterInfoOnExecutor(config.getBroadcastableClusterInfo());
        this.lowestCassandraVersion = config.getLowestCassandraVersion();
        this.bridge = this.buildCassandraBridge();
        this.jobInfo = this.reconstructJobInfoOnExecutor(config.getBroadcastableJobInfo());
        this.schemaInfo = this.reconstructSchemaInfoOnExecutor(config.getBroadcastableSchemaInfo());
        this.jobStatsPublisher = this.buildJobStatsPublisher();
        this.transportContext = this.buildTransportContext(false);
    }

    public final BulkSparkConf bulkSparkConf() {
        return this.conf;
    }

    protected final int sparkDefaultParallelism() {
        return this.sparkDefaultParallelism;
    }

    protected String lowestCassandraVersion() {
        return this.lowestCassandraVersion;
    }

    protected abstract ClusterInfo buildClusterInfo();

    protected ClusterInfo reconstructClusterInfoOnExecutor(IBroadcastableClusterInfo clusterInfo) {
        return clusterInfo.reconstruct();
    }

    protected JobInfo reconstructJobInfoOnExecutor(BroadcastableJobInfo jobInfo) {
        return new CassandraJobInfo(jobInfo);
    }

    protected SchemaInfo reconstructSchemaInfoOnExecutor(BroadcastableSchemaInfo schemaInfo) {
        return new CassandraSchemaInfo(schemaInfo);
    }

    protected abstract void validateKeyspaceReplication();

    protected JobInfo buildJobInfo() {
        this.validateKeyspaceReplication();
        BulkSparkConf conf = this.bulkSparkConf();
        TokenRangeMapping<RingInstance> tokenRangeMapping = this.cluster().getTokenRangeMapping(true);
        TokenPartitioner tokenPartitioner = new TokenPartitioner(tokenRangeMapping, conf.numberSplits, this.sparkDefaultParallelism(), conf.getCores());
        return new CassandraJobInfo(conf, this.generateRestoreJobIds(), tokenPartitioner);
    }

    protected abstract MultiClusterContainer<UUID> generateRestoreJobIds();

    protected CassandraBridge buildCassandraBridge() {
        return CassandraBridgeFactory.get(this.lowestCassandraVersion());
    }

    protected TransportContext buildTransportContext(boolean isOnDriver) {
        return this.createTransportContext(isOnDriver);
    }

    protected JobStatsPublisher buildJobStatsPublisher() {
        return new LogStatsPublisher();
    }

    protected String findLowestCassandraVersion() {
        return this.cluster().getLowestCassandraVersion();
    }

    protected SchemaInfo buildSchemaInfo(StructType structType) {
        QualifiedTableName tableName = this.job().qualifiedTableName();
        String keyspace = tableName.keyspace();
        String table = tableName.table();
        String keyspaceSchema = this.cluster().getKeyspaceSchema(true);
        Partitioner partitioner = this.cluster().getPartitioner();
        String createTableSchema = CqlUtils.extractTableSchema((String)keyspaceSchema, (String)keyspace, (String)table);
        Set udts = CqlUtils.extractUdts((String)keyspaceSchema, (String)keyspace);
        ReplicationFactor replicationFactor = CqlUtils.extractReplicationFactor((String)keyspaceSchema, (String)keyspace);
        int indexCount = CqlUtils.extractIndexCount((String)keyspaceSchema, (String)keyspace, (String)table);
        CqlTable cqlTable = this.bridge().buildSchema(createTableSchema, keyspace, replicationFactor, partitioner, udts, null, indexCount, false);
        CqlTableInfoProvider tableInfoProvider = new CqlTableInfoProvider(createTableSchema, cqlTable);
        TableSchema tableSchema = this.initializeTableSchema(this.bulkSparkConf(), structType, tableInfoProvider, this.lowestCassandraVersion());
        return new CassandraSchemaInfo(tableSchema, udts);
    }

    @Override
    public JobInfo job() {
        return this.jobInfo;
    }

    @Override
    public ClusterInfo cluster() {
        return this.clusterInfo;
    }

    @Override
    public SchemaInfo schema() {
        return this.schemaInfo;
    }

    @Override
    public CassandraBridge bridge() {
        this.bridge = this.getOrRebuildAfterDeserialization(() -> this.bridge, this::buildCassandraBridge);
        return this.bridge;
    }

    @Override
    public JobStatsPublisher jobStats() {
        this.jobStatsPublisher = this.getOrRebuildAfterDeserialization(() -> this.jobStatsPublisher, this::buildJobStatsPublisher);
        return this.jobStatsPublisher;
    }

    @Override
    public TransportContext transportContext() {
        this.transportContext = this.getOrRebuildAfterDeserialization(() -> this.transportContext, () -> this.buildTransportContext(false));
        return this.transportContext;
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down bulk writer context. contextClass={}", (Object)this.getClass().getSimpleName());
        if (this.clusterInfo != null) {
            this.clusterInfo.close();
        }
        if (this.transportContext != null) {
            this.transportContext.close();
        }
    }

    @NotNull
    protected TableSchema initializeTableSchema(@NotNull BulkSparkConf conf, @NotNull StructType dfSchema, TableInfoProvider tableInfoProvider, String lowestCassandraVersion) {
        return new TableSchema(dfSchema, tableInfoProvider, conf.writeMode, conf.getTTLOptions(), conf.getTimestampOptions(), lowestCassandraVersion, this.job().qualifiedTableName().quoteIdentifiers());
    }

    @NotNull
    protected TransportContext createTransportContext(boolean isOnDriver) {
        BulkSparkConf conf = this.bulkSparkConf();
        return conf.getTransportInfo().getTransport().createContext(this, conf, isOnDriver);
    }

    public void write(Kryo kryo, Output output) {
        this.failIfKryoNotRegistered();
    }

    public void read(Kryo kryo, Input input) {
        this.failIfKryoNotRegistered();
    }

    private void failIfKryoNotRegistered() {
        this.logger.error(KRYO_REGISTRATION_WARNING);
        throw new RuntimeException(KRYO_REGISTRATION_WARNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrRebuildAfterDeserialization(Supplier<T> current, Supplier<T> builder) {
        T t = current.get();
        if (t != null) {
            return t;
        }
        AbstractBulkWriterContext abstractBulkWriterContext = this;
        synchronized (abstractBulkWriterContext) {
            t = current.get();
            if (t != null) {
                return t;
            }
            return builder.get();
        }
    }
}

