/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.ByteBuffer;
import javax.crypto.Mac;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class AesCbcHmacJweEncryption
extends JweEncryption {
    public AesCbcHmacJweEncryption(ContentAlgorithm cekAlgoJwt, KeyEncryptionProvider keyEncryptionAlgorithm) {
        this(cekAlgoJwt, keyEncryptionAlgorithm, false);
    }

    public AesCbcHmacJweEncryption(ContentAlgorithm cekAlgoJwt, KeyEncryptionProvider keyEncryptionAlgorithm, boolean generateCekOnce) {
        super(keyEncryptionAlgorithm, new AesCbcContentEncryptionAlgorithm(cekAlgoJwt, generateCekOnce));
    }

    public AesCbcHmacJweEncryption(ContentAlgorithm cekAlgoJwt, byte[] cek, byte[] iv, KeyEncryptionProvider keyEncryptionAlgorithm) {
        super(keyEncryptionAlgorithm, new AesCbcContentEncryptionAlgorithm(cek, iv, cekAlgoJwt));
    }

    public AesCbcHmacJweEncryption(KeyEncryptionProvider keyEncryptionAlgorithm, AesCbcContentEncryptionAlgorithm contentEncryptionAlgorithm) {
        super(keyEncryptionAlgorithm, contentEncryptionAlgorithm);
    }

    @Override
    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return AesCbcHmacJweEncryption.doGetActualCek(theCek, algoJwt);
    }

    protected static byte[] doGetActualCek(byte[] theCek, String algoJwt) {
        int inputKeySize = AesCbcContentEncryptionAlgorithm.getFullCekKeySize(algoJwt);
        if (theCek.length != inputKeySize) {
            LOG.warning("Length input key [" + theCek.length + "] invalid for algorithm " + algoJwt + " [" + inputKeySize + "]");
            throw new JweException(JweException.Error.INVALID_CONTENT_KEY);
        }
        int secondaryKeySize = inputKeySize / 2;
        byte[] encKey = new byte[secondaryKeySize];
        System.arraycopy(theCek, secondaryKeySize, encKey, 0, secondaryKeySize);
        return encKey;
    }

    @Override
    protected byte[] getActualCipher(byte[] cipher) {
        return cipher;
    }

    @Override
    protected byte[] getAuthenticationTag(AbstractJweEncryption.JweEncryptionInternal state, byte[] cipher) {
        MacState macState = this.getInitializedMacState(state);
        macState.mac.update(cipher);
        return AesCbcHmacJweEncryption.signAndGetTag(macState);
    }

    protected static byte[] signAndGetTag(MacState macState) {
        macState.mac.update(macState.al);
        byte[] sig = macState.mac.doFinal();
        int authTagLen = 16;
        byte[] authTag = new byte[authTagLen];
        System.arraycopy(sig, 0, authTag, 0, authTagLen);
        return authTag;
    }

    private MacState getInitializedMacState(AbstractJweEncryption.JweEncryptionInternal state) {
        return AesCbcHmacJweEncryption.getInitializedMacState(state.secretKey, state.theIv, state.aad, state.theHeaders, state.protectedHeadersJson);
    }

    protected static MacState getInitializedMacState(byte[] secretKey, byte[] theIv, byte[] extraAad, JweHeaders theHeaders, String protectedHeadersJson) {
        String algoJwt = theHeaders.getContentEncryptionAlgorithm().getJwaName();
        int size = AesCbcContentEncryptionAlgorithm.getFullCekKeySize(algoJwt) / 2;
        byte[] macKey = new byte[size];
        System.arraycopy(secretKey, 0, macKey, 0, size);
        String hmacAlgoJava = AesCbcContentEncryptionAlgorithm.getHMACAlgorithm(algoJwt);
        Mac mac = HmacUtils.getInitializedMac((byte[])macKey, (String)hmacAlgoJava, null);
        byte[] aad = JweUtils.getAdditionalAuthenticationData(protectedHeadersJson, extraAad);
        ByteBuffer buf = ByteBuffer.allocate(8);
        byte[] al = buf.putInt(0).putInt(aad.length * 8).array();
        mac.update(aad);
        mac.update(theIv);
        MacState macState = new MacState();
        macState.mac = mac;
        macState.al = al;
        return macState;
    }

    @Override
    protected AuthenticationTagProducer getAuthenticationTagProducer(AbstractJweEncryption.JweEncryptionInternal state) {
        final MacState macState = this.getInitializedMacState(state);
        return new AuthenticationTagProducer(){

            @Override
            public void update(byte[] cipher, int off, int len) {
                macState.mac.update(cipher, off, len);
            }

            @Override
            public byte[] getTag() {
                return AesCbcHmacJweEncryption.signAndGetTag(macState);
            }
        };
    }

    @Override
    protected byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
        return this.getKeyEncryptionAlgo().getEncryptedContentEncryptionKey(headers, theCek);
    }

    protected static class MacState {
        protected Mac mac;
        private byte[] al;

        protected MacState() {
        }
    }
}

