/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.auth.signatures;

import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import org.tomitribe.auth.signatures.Algorithm;
import org.tomitribe.auth.signatures.Base64;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signatures;
import org.tomitribe.auth.signatures.UnsupportedAlgorithmException;

public class Signer {
    private final Sign sign;
    private final Signature signature;
    private final Algorithm algorithm;
    private final Provider provider;

    public Signer(Key key, Signature signature) {
        this(key, signature, null);
    }

    public Signer(Key key, Signature signature, Provider provider) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.signature = Objects.requireNonNull(signature, "Signature cannot be null");
        this.algorithm = signature.getAlgorithm();
        this.provider = provider;
        if (java.security.Signature.class.equals((Object)this.algorithm.getType())) {
            this.sign = new Asymmetric((PrivateKey)PrivateKey.class.cast(key));
        } else if (Mac.class.equals((Object)this.algorithm.getType())) {
            this.sign = new Symmetric(key);
        } else {
            throw new UnsupportedAlgorithmException(String.format("Unknown Algorithm type %s %s", this.algorithm.getPortableName(), this.algorithm.getType().getName()));
        }
        try {
            this.sign.sign("validation".getBytes());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialise the Signer using the provided algorithm and key", e);
        }
    }

    public Signature sign(String method, String uri, Map<String, String> headers) throws IOException {
        Long created = System.currentTimeMillis();
        Long expires = this.signature.getSignatureMaxValidityMilliseconds();
        if (expires != null) {
            expires = expires + created;
        }
        String signingString = this.createSigningString(method, uri, headers, created, expires);
        byte[] binarySignature = this.sign.sign(signingString.getBytes("UTF-8"));
        byte[] encoded = Base64.encodeBase64(binarySignature);
        String signedAndEncodedString = new String(encoded, "UTF-8");
        return new Signature(this.signature.getKeyId(), this.signature.getSigningAlgorithm(), this.signature.getAlgorithm(), this.signature.getParameterSpec(), signedAndEncodedString, this.signature.getHeaders(), null, created, expires);
    }

    public String createSigningString(String method, String uri, Map<String, String> headers, Long created, Long expires) throws IOException {
        return Signatures.createSigningString(this.signature.getHeaders(), method, uri, headers, created, expires);
    }

    public String createSigningString(String method, String uri, Map<String, String> headers) throws IOException {
        return Signatures.createSigningString(this.signature.getHeaders(), method, uri, headers, this.signature.getSignatureCreationTimeMilliseconds(), this.signature.getSignatureExpirationTimeMilliseconds());
    }

    private class Symmetric
    implements Sign {
        private final Key key;

        private Symmetric(Key key) {
            this.key = key;
        }

        @Override
        public byte[] sign(byte[] signingStringBytes) {
            try {
                Mac mac = Signer.this.provider == null ? Mac.getInstance(Signer.this.algorithm.getJvmName()) : Mac.getInstance(Signer.this.algorithm.getJvmName(), Signer.this.provider);
                mac.init(this.key);
                return mac.doFinal(signingStringBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(Signer.this.algorithm.getJvmName());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class Asymmetric
    implements Sign {
        private final PrivateKey key;

        private Asymmetric(PrivateKey key) {
            this.key = key;
        }

        @Override
        public byte[] sign(byte[] signingStringBytes) {
            try {
                java.security.Signature instance;
                java.security.Signature signature = instance = Signer.this.provider == null ? java.security.Signature.getInstance(Signer.this.algorithm.getJvmName()) : java.security.Signature.getInstance(Signer.this.algorithm.getJvmName(), Signer.this.provider);
                if (Signer.this.signature.getParameterSpec() != null) {
                    instance.setParameter(Signer.this.signature.getParameterSpec());
                }
                instance.initSign(this.key);
                instance.update(signingStringBytes);
                return instance.sign();
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(Signer.this.algorithm.getJvmName());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static interface Sign {
        public byte[] sign(byte[] var1);
    }
}

